/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.compiler.datamodel.YangDeviationHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.linker.impl.YangLinkerManager;
import org.onosproject.yang.compiler.tool.YangModuleExtendedInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.runtime.helperutils.YangApacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeHelper {
    public static final String PERIOD = ".";
    public static final String DEFAULT_CAPS = "Default";
    public static final String UNDER_SCORE = "_";
    private static final String SERVICE = "Service";
    private static final Logger log = LoggerFactory.getLogger(RuntimeHelper.class);

    private RuntimeHelper() {
    }

    public static YangModel getModel(Class<?> aClass) {
        return YangApacheUtils.getYangModel(aClass);
    }

    public static Set<YangNode> getNodes(YangModel model, ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore) {
        HashSet<YangNode> selfNodes = new HashSet<YangNode>();
        HashSet<YangNode> nodes = new HashSet<YangNode>();
        for (YangModule info : model.getYangModules()) {
            YangModuleExtendedInfo ex = (YangModuleExtendedInfo)info;
            YangNode node = ex.getSchema();
            if (ex.isInterJar()) {
                String name = node.getName();
                String date = DataModelUtils.getDateInStringFormat(node);
                String revName = name;
                if (date != null) {
                    revName = name + "@" + date;
                }
                ConcurrentMap ss = (ConcurrentMap)yangSchemaStore.get(name);
                Preconditions.checkNotNull((Object)ss, (String)"schema %s not found", (Object)name);
                node = (YangNode)ss.get(revName);
            } else {
                selfNodes.add(node);
            }
            nodes.add(node);
        }
        RuntimeHelper.addLinkerAndJavaInfo(nodes);
        return selfNodes;
    }

    public static Set<YangNode> getSelfNodes(YangModel model, ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore) {
        HashSet<YangNode> nodes = new HashSet<YangNode>();
        for (YangModule info : model.getYangModules()) {
            YangModuleExtendedInfo ex = (YangModuleExtendedInfo)info;
            if (ex.isInterJar()) continue;
            nodes.add(ex.getSchema());
        }
        return nodes;
    }

    public static Set<YangNode> addLinkerAndJavaInfo(Set<YangNode> nodes) {
        YangLinkerManager yangLinker = new YangLinkerManager();
        yangLinker.resolveDependencies(nodes);
        for (YangNode node : nodes) {
            if (((YangDeviationHolder)((Object)node)).isModuleForDeviation()) continue;
            try {
                JavaCodeGeneratorUtil.translate(node, new YangPluginConfig(), false);
            }
            catch (IOException e) {
                log.error("failed to target link node {},", (Object)node.getName());
            }
        }
        return nodes;
    }

    public static String getInterfaceClassName(YangSchemaNode schemaNode) {
        return schemaNode.getJavaPackage() + PERIOD + RuntimeHelper.getCapitalCase(schemaNode.getJavaClassNameOrBuiltInType());
    }

    public static String getServiceName(YangSchemaNode schemaNode) {
        return RuntimeHelper.getInterfaceClassName(schemaNode) + SERVICE;
    }

    public static String getCapitalCase(String yangIdentifier) {
        yangIdentifier = yangIdentifier.substring(0, 1).toUpperCase() + yangIdentifier.substring(1);
        return RuntimeHelper.restrictConsecutiveCapitalCase(yangIdentifier);
    }

    private static String restrictConsecutiveCapitalCase(String consecCapitalCaseRemover) {
        for (int k = 0; k < consecCapitalCaseRemover.length(); ++k) {
            if (k + 1 >= consecCapitalCaseRemover.length() || !Character.isUpperCase(consecCapitalCaseRemover.charAt(k)) || !Character.isUpperCase(consecCapitalCaseRemover.charAt(k + 1))) continue;
            consecCapitalCaseRemover = consecCapitalCaseRemover.substring(0, k + 1) + consecCapitalCaseRemover.substring(k + 1, k + 2).toLowerCase() + consecCapitalCaseRemover.substring(k + 2);
        }
        return consecCapitalCaseRemover;
    }
}

