/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.DataNodeListener;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.YobHandler;
import org.onosproject.yang.runtime.impl.YobHandlerFactory;
import org.onosproject.yang.runtime.impl.YobUtils;
import org.onosproject.yang.runtime.impl.YobWorkBench;

class YobListener
implements DataNodeListener {
    private final YobHandlerFactory handlerFactory;
    private final DefaultYangModelRegistry registry;
    private final Stack<YobWorkBench> wbStack;
    private YangSchemaNode lastIndexSchema;
    private List<ModelObject> modelObjectList;

    public YobListener(YangSchemaNode node, DefaultYangModelRegistry reg) {
        this.lastIndexSchema = node;
        this.handlerFactory = YobHandlerFactory.instance();
        this.registry = reg;
        this.wbStack = new Stack();
        this.modelObjectList = new LinkedList<ModelObject>();
    }

    public List<ModelObject> modelObjectList() {
        return this.modelObjectList;
    }

    public void modelObjectList(List<ModelObject> moList) {
        this.modelObjectList = moList;
    }

    public Stack<YobWorkBench> wbStack() {
        return this.wbStack;
    }

    public YangSchemaNode lastIndexSchema() {
        return this.lastIndexSchema;
    }

    public void lastIndexSchema(YangSchemaNode schemaNode) {
        this.lastIndexSchema = schemaNode;
    }

    @Override
    public void enterDataNode(DataNode node) {
        YangSchemaNode schemaNode;
        SchemaId schemaId = node.key().schemaId();
        if (schemaId.name().equals("/")) {
            return;
        }
        if (this.wbStack.isEmpty() && this.lastIndexSchema == null) {
            schemaNode = (YangSchemaNode)this.registry.getChildContext(schemaId);
        } else if (this.wbStack.isEmpty() && this.lastIndexSchema != null) {
            schemaNode = (YangSchemaNode)SerializerHelper.getChildSchemaContext(this.lastIndexSchema, schemaId.name(), schemaId.namespace());
        } else {
            YangSchemaNode parentContext = this.wbStack.peek().schemaNode();
            schemaNode = (YangSchemaNode)SerializerHelper.getChildSchemaContext(parentContext, schemaId.name(), schemaId.namespace());
        }
        YobHandler nodeHandler = this.handlerFactory.getYobHandlerForContext(node.type());
        YobWorkBench workBench = nodeHandler.createObject(schemaNode, this.registry);
        if (workBench != null) {
            this.wbStack.push(workBench);
        }
    }

    @Override
    public void exitDataNode(DataNode node) {
        YobWorkBench curWb;
        SchemaId schemaId = node.key().schemaId();
        if (schemaId.name().equals("/")) {
            return;
        }
        YobWorkBench parentWb = null;
        if (node instanceof InnerNode) {
            if (this.wbStack.size() == 1 || !this.wbStack.isEmpty() && this.wbStack.peek().schemaNode().getParentContext() instanceof YangRpc) {
                YobWorkBench curWb2 = this.wbStack.pop();
                YobHandler nodeHandler = this.handlerFactory.getYobHandlerForContext(node.type());
                nodeHandler.buildObject(curWb2, this.registry);
                this.modelObjectList.add((ModelObject)curWb2.getBuiltObject());
                return;
            }
            curWb = this.wbStack.pop();
            parentWb = this.wbStack.peek();
        } else {
            if (this.wbStack.isEmpty()) {
                ModelObject obj = YobUtils.buildLeafModelObject(node, this.lastIndexSchema, this.registry);
                this.modelObjectList.add(obj);
                return;
            }
            curWb = this.wbStack.peek();
        }
        YobHandler nodeHandler = this.handlerFactory.getYobHandlerForContext(node.type());
        nodeHandler.buildObject(curWb, this.registry);
        nodeHandler.setInParent(node, curWb, parentWb, this.registry);
    }
}

