/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv4multicastsourceaddress.Ipv4MulticastSourceAddressUnion;
import java.util.Objects;

/**
 * Represents the implementation of ipv4MulticastSourceAddress.
 */
public final class Ipv4MulticastSourceAddress {

    private Ipv4MulticastSourceAddressUnion union;

    /**
     * Creates an instance of ipv4MulticastSourceAddress.
     */
    private Ipv4MulticastSourceAddress() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Ipv4MulticastSourceAddress(Ipv4MulticastSourceAddressUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of ipv4MulticastSourceAddress for type union.
     *
     * @param value value of ipv4MulticastSourceAddress for type union
     * @return ipv4MulticastSourceAddress for type union
     */
    public static Ipv4MulticastSourceAddress of(Ipv4MulticastSourceAddressUnion value) {
        return new Ipv4MulticastSourceAddress(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public Ipv4MulticastSourceAddressUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(Ipv4MulticastSourceAddressUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv4MulticastSourceAddress) {
            Ipv4MulticastSourceAddress other = (Ipv4MulticastSourceAddress) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of ipv4MulticastSourceAddress fromString input String ipv4MulticastSourceAddress.
     *
     * @param valInString value of input String
     * @return ipv4MulticastSourceAddress
     */
    public static Ipv4MulticastSourceAddress fromString(String valInString) {
        try {
            Ipv4MulticastSourceAddressUnion tmpVal = Ipv4MulticastSourceAddressUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
