/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of oamAlertLabel.
 */
public abstract class OamAlertLabel extends MplsLabelSpecialPurposeValue {

    /**
     * Returns the attribute oam-alert-label.
     *
     * @return oam-alert-label value of oam-alert-label
     */
    public static String oamAlertLabelToString() {
        return "oam-alert-label";
    }

    /**
     * Returns the object of oamAlertLabel fromString input String oamAlertLabel.
     *
     * @param valInString value of input String
     * @return oamAlertLabel
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("oam-alert-label")) {
            return OamAlertLabel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}