/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of x121.
 */
public abstract class X121 extends AddressFamily {

    /**
     * Returns the attribute x121.
     *
     * @return x121 value of x121
     */
    public static String x121ToString() {
        return "x121";
    }

    /**
     * Returns the object of x121 fromString input String x121.
     *
     * @param valInString value of input String
     * @return x121
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("x121")) {
            return X121.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}