/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipmulticastgroupaddress;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.Ipv4MulticastGroupAddress;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.Ipv6MulticastGroupAddress;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of ipMulticastGroupAddressUnion.
 */
public final class IpMulticastGroupAddressUnion {
    private Ipv4MulticastGroupAddress ipv4MulticastGroupAddress;
    private Ipv6MulticastGroupAddress ipv6MulticastGroupAddress;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of ipMulticastGroupAddressUnion.
     */
    private IpMulticastGroupAddressUnion() {
    }

    /**
     * Creates an instance of ipv4MulticastGroupAddress.
     *
     * @param ipv4MulticastGroupAddress value of ipv4MulticastGroupAddress
     */
    public IpMulticastGroupAddressUnion(Ipv4MulticastGroupAddress ipv4MulticastGroupAddress) {
        setValue.set(0);
        this.ipv4MulticastGroupAddress = ipv4MulticastGroupAddress;
    }

    /**
     * Creates an instance of ipv6MulticastGroupAddress.
     *
     * @param ipv6MulticastGroupAddress value of ipv6MulticastGroupAddress
     */
    public IpMulticastGroupAddressUnion(Ipv6MulticastGroupAddress ipv6MulticastGroupAddress) {
        setValue.set(1);
        this.ipv6MulticastGroupAddress = ipv6MulticastGroupAddress;
    }

    /**
     * Returns the object of ipMulticastGroupAddressUnion for type ipv4MulticastGroupAddress.
     *
     * @param value value of ipMulticastGroupAddressUnion for type ipv4MulticastGroupAddress
     * @return ipMulticastGroupAddressUnion for type ipv4MulticastGroupAddress
     */
    public static IpMulticastGroupAddressUnion of(Ipv4MulticastGroupAddress value) {
        return new IpMulticastGroupAddressUnion(value);
    }

    /**
     * Returns the object of ipMulticastGroupAddressUnion for type ipv6MulticastGroupAddress.
     *
     * @param value value of ipMulticastGroupAddressUnion for type ipv6MulticastGroupAddress
     * @return ipMulticastGroupAddressUnion for type ipv6MulticastGroupAddress
     */
    public static IpMulticastGroupAddressUnion of(Ipv6MulticastGroupAddress value) {
        return new IpMulticastGroupAddressUnion(value);
    }

    /**
     * Returns the attribute ipv4MulticastGroupAddress.
     *
     * @return ipv4MulticastGroupAddress value of ipv4MulticastGroupAddress
     */
    public Ipv4MulticastGroupAddress ipv4MulticastGroupAddress() {
        return ipv4MulticastGroupAddress;
    }
    /**
     * Returns the attribute ipv6MulticastGroupAddress.
     *
     * @return ipv6MulticastGroupAddress value of ipv6MulticastGroupAddress
     */
    public Ipv6MulticastGroupAddress ipv6MulticastGroupAddress() {
        return ipv6MulticastGroupAddress;
    }
    /**
     * Sets the attribute ipv4MulticastGroupAddress.
     *
     * @param ipv4MulticastGroupAddress value of ipv4MulticastGroupAddress
     */
    public void ipv4MulticastGroupAddress(Ipv4MulticastGroupAddress ipv4MulticastGroupAddress) {
        this.ipv4MulticastGroupAddress = ipv4MulticastGroupAddress;
    }
    /**
     * Sets the attribute ipv6MulticastGroupAddress.
     *
     * @param ipv6MulticastGroupAddress value of ipv6MulticastGroupAddress
     */
    public void ipv6MulticastGroupAddress(Ipv6MulticastGroupAddress ipv6MulticastGroupAddress) {
        this.ipv6MulticastGroupAddress = ipv6MulticastGroupAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipv4MulticastGroupAddress, ipv6MulticastGroupAddress);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpMulticastGroupAddressUnion) {
            IpMulticastGroupAddressUnion other = (IpMulticastGroupAddressUnion) obj;
            return
                Objects.deepEquals(ipv4MulticastGroupAddress, other.ipv4MulticastGroupAddress) &&
                Objects.deepEquals(ipv6MulticastGroupAddress, other.ipv6MulticastGroupAddress);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return ipv4MulticastGroupAddress.toString();
        }
        if (setValue.get(1)) {
            return ipv6MulticastGroupAddress.toString();
        }
        return null;
    }
    /**
     * Returns the object of ipMulticastGroupAddressUnion fromString input String ipMulticastGroupAddressUnion.
     *
     * @param valInString value of input String
     * @return ipMulticastGroupAddressUnion
     */
    public static IpMulticastGroupAddressUnion fromString(String valInString) {
        try {
            Ipv4MulticastGroupAddress tmpVal = Ipv4MulticastGroupAddress.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Ipv6MulticastGroupAddress tmpVal = Ipv6MulticastGroupAddress.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
