/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds16.timervalueseconds16union;

/**
 * Represents ENUM data of timerValueSeconds16UnionEnum1.
 */
public enum TimerValueSeconds16UnionEnum1 {

    /**
     * Represents infinity.
     */
    INFINITY(0, "infinity"),

    /**
     * Represents not-set.
     */
    NOT_SET(1, "not-set");

    private int timerValueSeconds16UnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of timerValueSeconds16UnionEnum1.
     *
     * @param timerValueSeconds16UnionEnum1 value of timerValueSeconds16UnionEnum1
     */
     TimerValueSeconds16UnionEnum1(int timerValueSeconds16UnionEnum1, String schemaName) {
        this.timerValueSeconds16UnionEnum1 = timerValueSeconds16UnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of timerValueSeconds16UnionEnum1 for.
     *
     * @param value value of timerValueSeconds16UnionEnum1 for
     * @return timerValueSeconds16UnionEnum1 for
     */
    public static TimerValueSeconds16UnionEnum1 of(int value) {
        switch (value) {
            case 0:
                return TimerValueSeconds16UnionEnum1.INFINITY;
            case 1:
                return TimerValueSeconds16UnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of timerValueSeconds16UnionEnum1 for.
     *
     * @param value value of timerValueSeconds16UnionEnum1 for
     * @return timerValueSeconds16UnionEnum1 for
     */
    public static TimerValueSeconds16UnionEnum1 of(String value) {
        switch (value) {
            case "infinity":
                return TimerValueSeconds16UnionEnum1.INFINITY;
            case "not-set":
                return TimerValueSeconds16UnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute timerValueSeconds16UnionEnum1.
     *
     * @return timerValueSeconds16UnionEnum1 value of timerValueSeconds16UnionEnum1
     */
    public int timerValueSeconds16UnionEnum1() {
        return timerValueSeconds16UnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
