/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of pathInvalidationActionType.
 */
public abstract class PathInvalidationActionType {

    /**
     * Returns the attribute path-invalidation-action-type.
     *
     * @return path-invalidation-action-type value of path-invalidation-action-type
     */
    public static String pathInvalidationActionTypeToString() {
        return "path-invalidation-action-type";
    }

    /**
     * Returns the object of pathInvalidationActionType fromString input String pathInvalidationActionType.
     *
     * @param valInString value of input String
     * @return pathInvalidationActionType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-invalidation-action-type")) {
            return PathInvalidationActionType.class;
        } else if (valInString.equals("path-invalidation-action-drop-type")) {
            return PathInvalidationActionDropType.class;
        } else if (valInString.equals("path-invalidation-action-drop-tear")) {
            return PathInvalidationActionDropTear.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}