/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.tepathdisjointness;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of bits.
 */
public enum Bits {

    /**
     * Represents node.
     */
    NODE(0, "node"),

    /**
     * Represents link.
     */
    LINK(1, "link"),

    /**
     * Represents srlg.
     */
    SRLG(2, "srlg");

    private int bits;
    private String schemaName;

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
     Bits(int bits, String schemaName) {
        this.bits = bits;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(int value) {
        switch (value) {
            case 0:
                return Bits.NODE;
            case 1:
                return Bits.LINK;
            case 2:
                return Bits.SRLG;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(String value) {
        switch (value) {
            case "node":
                return Bits.NODE;
            case "link":
                return Bits.LINK;
            case "srlg":
                return Bits.SRLG;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public int bits() {
        return bits;
    }

    /**
     * Returns the object of bits fromString input String bits.
     *
     * @param valInString value of input String
     * @return bits
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Bits bits = of(bitName);
            if (bits != null) {
                tmpVal.set(bits.bits());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Bits.NODE.bits())) {
            sBuild.append("node");
            sBuild.append(" ");
        }
        if (bits.get(Bits.LINK.bits())) {
            sBuild.append("link");
            sBuild.append(" ");
        }
        if (bits.get(Bits.SRLG.bits())) {
            sBuild.append("srlg");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
