/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of list56.
 */
public interface List56 extends Augmentable  {

    /**
     * Identify the leaf of List56.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf58.
         */
        LEAF58(1),
        /**
         * Represents leaf57.
         */
        LEAF57(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf58.
     *
     * @return leaf58 value of leaf58
     */
    String leaf58();

    /**
     * Returns the attribute leaf57.
     *
     * @return leaf57 list of leaf57
     */
    List<String> leaf57();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf58.
     *
     * @param leaf58 value of leaf58
     */
    void leaf58(String leaf58);

    /**
     * Sets the attribute leaf57.
     *
     * @param leaf57 list of leaf57
     */
    void leaf57(List<String> leaf57);

    /**
     * Adds to the list of leaf57.
     *
     * @param addTo value of leaf57
     */
    void addToLeaf57(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}