/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.TcDemandedTunnel;

/**
 * Represents the implementation of transportConstraint.
 */
public abstract class TransportConstraint {

    /**
     * Returns the attribute transport-constraint.
     *
     * @return transport-constraint value of transport-constraint
     */
    public static String transportConstraintToString() {
        return "transport-constraint";
    }

    /**
     * Returns the object of transportConstraint fromString input String transportConstraint.
     *
     * @param valInString value of input String
     * @return transportConstraint
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("transport-constraint")) {
            return TransportConstraint.class;
        } else if (valInString.equals("tc-latency")) {
            return TcLatency.class;
        } else if (valInString.equals("tc-jitter")) {
            return TcJitter.class;
        } else if (valInString.equals("tc-bandwidth")) {
            return TcBandwidth.class;
        } else if (valInString.equals("tc-path-diversity")) {
            return TcPathDiversity.class;
        } else if (valInString.equals("tc-site-diversity")) {
            return TcSiteDiversity.class;
        } else if (valInString.equals("tc-demanded-tunnel")) {
            return TcDemandedTunnel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}