/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity.routetargetextendedcommunitycase2;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of routeTargetExtendedCommunity2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRouteTargetExtendedCommunity2 extends InnerModelObject implements RouteTargetExtendedCommunity2 {
    protected long globalAdministrator;
    protected int localAdministrator;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public long globalAdministrator() {
        return globalAdministrator;
    }

    @Override
    public int localAdministrator() {
        return localAdministrator;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void globalAdministrator(long globalAdministrator) {
        valueLeafFlags.set(LeafIdentifier.GLOBALADMINISTRATOR.getLeafIndex());
        this.globalAdministrator = globalAdministrator;
    }

    @Override
    public void localAdministrator(int localAdministrator) {
        valueLeafFlags.set(LeafIdentifier.LOCALADMINISTRATOR.getLeafIndex());
        this.localAdministrator = localAdministrator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(globalAdministrator, localAdministrator, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRouteTargetExtendedCommunity2) {
            DefaultRouteTargetExtendedCommunity2 other = (DefaultRouteTargetExtendedCommunity2) obj;
            return
                Objects.deepEquals(globalAdministrator, other.globalAdministrator) &&
                Objects.deepEquals(localAdministrator, other.localAdministrator) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("globalAdministrator=" + globalAdministrator)
            .add("localAdministrator=" + localAdministrator)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultRouteTargetExtendedCommunity2.
     */
    public DefaultRouteTargetExtendedCommunity2() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}