/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.CustomStream;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.YangPush;
import java.util.Objects;

/**
 * Represents the implementation of streamTypedef.
 */
public final class StreamTypedef {

    private Class<? extends StreamIdentity> identityref;

    /**
     * Creates an instance of streamTypedef.
     */
    private StreamTypedef() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public StreamTypedef(Class<? extends StreamIdentity> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of streamTypedef for type identityref.
     *
     * @param value value of streamTypedef for type identityref
     * @return streamTypedef for type identityref
     */
    public static StreamTypedef of(Class<? extends StreamIdentity> value) {
        return new StreamTypedef(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends StreamIdentity> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends StreamIdentity> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamTypedef) {
            StreamTypedef other = (StreamTypedef) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(StreamIdentity.class)) {
            return StreamIdentity.streamToString();
        } else if (identityref.equals(Netconf1.class)) {
            return Netconf1.netconf1ToString();
        } else if (identityref.equals(YangPush.class)) {
            return YangPush.yangPushToString();
        } else if (identityref.equals(CustomStream.class)) {
            return CustomStream.customStreamToString();
        }
        return null;
    }
    /**
     * Returns the object of streamTypedef fromString input String streamTypedef.
     *
     * @param valInString value of input String
     * @return streamTypedef
     */
    public static StreamTypedef fromString(String valInString) {
        try {
            Class<? extends StreamIdentity> tmpVal = StreamIdentity.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
