/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of subscriptionStreamStatus.
 */
public abstract class SubscriptionStreamStatus {

    /**
     * Returns the attribute subscription-stream-status.
     *
     * @return subscription-stream-status value of subscription-stream-status
     */
    public static String subscriptionStreamStatusToString() {
        return "subscription-stream-status";
    }

    /**
     * Returns the object of subscriptionStreamStatus fromString input String subscriptionStreamStatus.
     *
     * @param valInString value of input String
     * @return subscriptionStreamStatus
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("subscription-stream-status")) {
            return SubscriptionStreamStatus.class;
        } else if (valInString.equals("active")) {
            return Active.class;
        } else if (valInString.equals("inactive")) {
            return Inactive.class;
        } else if (valInString.equals("suspended")) {
            return Suspended.class;
        } else if (valInString.equals("in-error")) {
            return InError.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}