/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.subscriptions;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Encoding;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.StreamTypedef;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionId;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionStatus;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.basefilter.FilterType;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.pushsourceinfo.PushSource;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.receiverinfo.Receivers;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of subscription.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSubscription extends InnerModelObject 
        implements Subscription, MultiInstanceObject<SubscriptionKeys> {
    protected SubscriptionId subscriptionId;
    protected boolean configuredSubscription;
    protected SubscriptionStatus subscriptionStatus;
    protected StreamTypedef stream;
    protected Encoding encoding;
    protected DateAndTime startTime;
    protected DateAndTime stopTime;
    protected BitSet valueLeafFlags = new BitSet();
    protected FilterType filterType;
    protected Receivers receivers;
    protected PushSource pushSource;

    @Override
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    @Override
    public boolean configuredSubscription() {
        return configuredSubscription;
    }

    @Override
    public SubscriptionStatus subscriptionStatus() {
        return subscriptionStatus;
    }

    @Override
    public StreamTypedef stream() {
        return stream;
    }

    @Override
    public Encoding encoding() {
        return encoding;
    }

    @Override
    public DateAndTime startTime() {
        return startTime;
    }

    @Override
    public DateAndTime stopTime() {
        return stopTime;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public FilterType filterType() {
        return filterType;
    }

    @Override
    public Receivers receivers() {
        return receivers;
    }

    @Override
    public PushSource pushSource() {
        return pushSource;
    }

    @Override
    public void subscriptionId(SubscriptionId subscriptionId) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONID.getLeafIndex());
        this.subscriptionId = subscriptionId;
    }

    @Override
    public void configuredSubscription(boolean configuredSubscription) {
        valueLeafFlags.set(LeafIdentifier.CONFIGUREDSUBSCRIPTION.getLeafIndex());
        this.configuredSubscription = configuredSubscription;
    }

    @Override
    public void subscriptionStatus(SubscriptionStatus subscriptionStatus) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONSTATUS.getLeafIndex());
        this.subscriptionStatus = subscriptionStatus;
    }

    @Override
    public void stream(StreamTypedef stream) {
        valueLeafFlags.set(LeafIdentifier.STREAM.getLeafIndex());
        this.stream = stream;
    }

    @Override
    public void encoding(Encoding encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void startTime(DateAndTime startTime) {
        valueLeafFlags.set(LeafIdentifier.STARTTIME.getLeafIndex());
        this.startTime = startTime;
    }

    @Override
    public void stopTime(DateAndTime stopTime) {
        valueLeafFlags.set(LeafIdentifier.STOPTIME.getLeafIndex());
        this.stopTime = stopTime;
    }

    @Override
    public void filterType(FilterType filterType) {
        this.filterType = filterType;
    }

    @Override
    public void receivers(Receivers receivers) {
        this.receivers = receivers;
    }

    @Override
    public void pushSource(PushSource pushSource) {
        this.pushSource = pushSource;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId, configuredSubscription, subscriptionStatus, stream, encoding, startTime, stopTime, valueLeafFlags, filterType, receivers, pushSource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSubscription) {
            DefaultSubscription other = (DefaultSubscription) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId) &&
                Objects.deepEquals(configuredSubscription, other.configuredSubscription) &&
                Objects.deepEquals(subscriptionStatus, other.subscriptionStatus) &&
                Objects.deepEquals(stream, other.stream) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(startTime, other.startTime) &&
                Objects.deepEquals(stopTime, other.stopTime) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(filterType, other.filterType) &&
                Objects.deepEquals(receivers, other.receivers) &&
                Objects.deepEquals(pushSource, other.pushSource);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionId=" + subscriptionId)
            .add("configuredSubscription=" + configuredSubscription)
            .add("subscriptionStatus=" + subscriptionStatus)
            .add("stream=" + stream)
            .add("encoding=" + encoding)
            .add("startTime=" + startTime)
            .add("stopTime=" + stopTime)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("filterType=" + filterType)
            .add("receivers=" + receivers)
            .add("pushSource=" + pushSource)
            .toString();
    }


    /**
     * Creates an instance of defaultSubscription.
     */
    public DefaultSubscription() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}