/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface;

/**
 * Represents ENUM data of operStatusEnum.
 */
public enum OperStatusEnum {

    /**
     * Represents up.
     */
    UP(1, "up"),

    /**
     * Represents down.
     */
    DOWN(2, "down"),

    /**
     * Represents testing.
     */
    TESTING(3, "testing"),

    /**
     * Represents unknown.
     */
    UNKNOWN(4, "unknown"),

    /**
     * Represents dormant.
     */
    DORMANT(5, "dormant"),

    /**
     * Represents not-present.
     */
    NOT_PRESENT(6, "not-present"),

    /**
     * Represents lower-layer-down.
     */
    LOWER_LAYER_DOWN(7, "lower-layer-down");

    private int operStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of operStatusEnum.
     *
     * @param operStatusEnum value of operStatusEnum
     */
     OperStatusEnum(int operStatusEnum, String schemaName) {
        this.operStatusEnum = operStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of operStatusEnum for.
     *
     * @param value value of operStatusEnum for
     * @return operStatusEnum for
     */
    public static OperStatusEnum of(int value) {
        switch (value) {
            case 1:
                return OperStatusEnum.UP;
            case 2:
                return OperStatusEnum.DOWN;
            case 3:
                return OperStatusEnum.TESTING;
            case 4:
                return OperStatusEnum.UNKNOWN;
            case 5:
                return OperStatusEnum.DORMANT;
            case 6:
                return OperStatusEnum.NOT_PRESENT;
            case 7:
                return OperStatusEnum.LOWER_LAYER_DOWN;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of operStatusEnum for.
     *
     * @param value value of operStatusEnum for
     * @return operStatusEnum for
     */
    public static OperStatusEnum of(String value) {
        switch (value) {
            case "up":
                return OperStatusEnum.UP;
            case "down":
                return OperStatusEnum.DOWN;
            case "testing":
                return OperStatusEnum.TESTING;
            case "unknown":
                return OperStatusEnum.UNKNOWN;
            case "dormant":
                return OperStatusEnum.DORMANT;
            case "not-present":
                return OperStatusEnum.NOT_PRESENT;
            case "lower-layer-down":
                return OperStatusEnum.LOWER_LAYER_DOWN;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute operStatusEnum.
     *
     * @return operStatusEnum value of operStatusEnum
     */
    public int operStatusEnum() {
        return operStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
