/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Counter32;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Counter64;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of statistics.
 */
public interface Statistics extends Augmentable  {

    /**
     * Identify the leaf of Statistics.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents discontinuityTime.
         */
        DISCONTINUITYTIME(1),
        /**
         * Represents inOctets.
         */
        INOCTETS(2),
        /**
         * Represents inUnicastPkts.
         */
        INUNICASTPKTS(3),
        /**
         * Represents inBroadcastPkts.
         */
        INBROADCASTPKTS(4),
        /**
         * Represents inMulticastPkts.
         */
        INMULTICASTPKTS(5),
        /**
         * Represents inDiscards.
         */
        INDISCARDS(6),
        /**
         * Represents inErrors.
         */
        INERRORS(7),
        /**
         * Represents inUnknownProtos.
         */
        INUNKNOWNPROTOS(8),
        /**
         * Represents outOctets.
         */
        OUTOCTETS(9),
        /**
         * Represents outUnicastPkts.
         */
        OUTUNICASTPKTS(10),
        /**
         * Represents outBroadcastPkts.
         */
        OUTBROADCASTPKTS(11),
        /**
         * Represents outMulticastPkts.
         */
        OUTMULTICASTPKTS(12),
        /**
         * Represents outDiscards.
         */
        OUTDISCARDS(13),
        /**
         * Represents outErrors.
         */
        OUTERRORS(14);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute discontinuityTime.
     *
     * @return discontinuityTime value of discontinuityTime
     */
    DateAndTime discontinuityTime();

    /**
     * Returns the attribute inOctets.
     *
     * @return inOctets value of inOctets
     */
    Counter64 inOctets();

    /**
     * Returns the attribute inUnicastPkts.
     *
     * @return inUnicastPkts value of inUnicastPkts
     */
    Counter64 inUnicastPkts();

    /**
     * Returns the attribute inBroadcastPkts.
     *
     * @return inBroadcastPkts value of inBroadcastPkts
     */
    Counter64 inBroadcastPkts();

    /**
     * Returns the attribute inMulticastPkts.
     *
     * @return inMulticastPkts value of inMulticastPkts
     */
    Counter64 inMulticastPkts();

    /**
     * Returns the attribute inDiscards.
     *
     * @return inDiscards value of inDiscards
     */
    Counter32 inDiscards();

    /**
     * Returns the attribute inErrors.
     *
     * @return inErrors value of inErrors
     */
    Counter32 inErrors();

    /**
     * Returns the attribute inUnknownProtos.
     *
     * @return inUnknownProtos value of inUnknownProtos
     */
    Counter32 inUnknownProtos();

    /**
     * Returns the attribute outOctets.
     *
     * @return outOctets value of outOctets
     */
    Counter64 outOctets();

    /**
     * Returns the attribute outUnicastPkts.
     *
     * @return outUnicastPkts value of outUnicastPkts
     */
    Counter64 outUnicastPkts();

    /**
     * Returns the attribute outBroadcastPkts.
     *
     * @return outBroadcastPkts value of outBroadcastPkts
     */
    Counter64 outBroadcastPkts();

    /**
     * Returns the attribute outMulticastPkts.
     *
     * @return outMulticastPkts value of outMulticastPkts
     */
    Counter64 outMulticastPkts();

    /**
     * Returns the attribute outDiscards.
     *
     * @return outDiscards value of outDiscards
     */
    Counter32 outDiscards();

    /**
     * Returns the attribute outErrors.
     *
     * @return outErrors value of outErrors
     */
    Counter32 outErrors();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute discontinuityTime.
     *
     * @param discontinuityTime value of discontinuityTime
     */
    void discontinuityTime(DateAndTime discontinuityTime);

    /**
     * Sets the attribute inOctets.
     *
     * @param inOctets value of inOctets
     */
    void inOctets(Counter64 inOctets);

    /**
     * Sets the attribute inUnicastPkts.
     *
     * @param inUnicastPkts value of inUnicastPkts
     */
    void inUnicastPkts(Counter64 inUnicastPkts);

    /**
     * Sets the attribute inBroadcastPkts.
     *
     * @param inBroadcastPkts value of inBroadcastPkts
     */
    void inBroadcastPkts(Counter64 inBroadcastPkts);

    /**
     * Sets the attribute inMulticastPkts.
     *
     * @param inMulticastPkts value of inMulticastPkts
     */
    void inMulticastPkts(Counter64 inMulticastPkts);

    /**
     * Sets the attribute inDiscards.
     *
     * @param inDiscards value of inDiscards
     */
    void inDiscards(Counter32 inDiscards);

    /**
     * Sets the attribute inErrors.
     *
     * @param inErrors value of inErrors
     */
    void inErrors(Counter32 inErrors);

    /**
     * Sets the attribute inUnknownProtos.
     *
     * @param inUnknownProtos value of inUnknownProtos
     */
    void inUnknownProtos(Counter32 inUnknownProtos);

    /**
     * Sets the attribute outOctets.
     *
     * @param outOctets value of outOctets
     */
    void outOctets(Counter64 outOctets);

    /**
     * Sets the attribute outUnicastPkts.
     *
     * @param outUnicastPkts value of outUnicastPkts
     */
    void outUnicastPkts(Counter64 outUnicastPkts);

    /**
     * Sets the attribute outBroadcastPkts.
     *
     * @param outBroadcastPkts value of outBroadcastPkts
     */
    void outBroadcastPkts(Counter64 outBroadcastPkts);

    /**
     * Sets the attribute outMulticastPkts.
     *
     * @param outMulticastPkts value of outMulticastPkts
     */
    void outMulticastPkts(Counter64 outMulticastPkts);

    /**
     * Sets the attribute outDiscards.
     *
     * @param outDiscards value of outDiscards
     */
    void outDiscards(Counter32 outDiscards);

    /**
     * Sets the attribute outErrors.
     *
     * @param outErrors value of outErrors
     */
    void outErrors(Counter32 outErrors);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}