/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes;

/**
 * Represents the implementation of bcModelMar.
 */
public abstract class BcModelMar extends BcModelType {

    /**
     * Returns the attribute bc-model-mar.
     *
     * @return bc-model-mar value of bc-model-mar
     */
    public static String bcModelMarToString() {
        return "bc-model-mar";
    }

    /**
     * Returns the object of bcModelMar fromString input String bcModelMar.
     *
     * @param valInString value of input String
     * @return bcModelMar
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bc-model-mar")) {
            return BcModelMar.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}