/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes;

/**
 * Represents the implementation of bcModelRdm.
 */
public abstract class BcModelRdm extends BcModelType {

    /**
     * Returns the attribute bc-model-rdm.
     *
     * @return bc-model-rdm value of bc-model-rdm
     */
    public static String bcModelRdmToString() {
        return "bc-model-rdm";
    }

    /**
     * Returns the object of bcModelRdm fromString input String bcModelRdm.
     *
     * @param valInString value of input String
     * @return bcModelRdm
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bc-model-rdm")) {
            return BcModelRdm.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}