/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmultimodulea.rev20160826;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbmultimodulea.rev20160826.ytbmultimodulea.Ytbmultilist;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbMultiModulea.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbMultiModuleaOpParam extends InnerModelObject implements YtbMultiModulea {
    protected List<Ytbmultilist> ytbmultilist;

    @Override
    public List<Ytbmultilist> ytbmultilist() {
        return ytbmultilist;
    }

    @Override
    public void ytbmultilist(List<Ytbmultilist> ytbmultilist) {
        this.ytbmultilist = ytbmultilist;
    }

    @Override
    public void addToYtbmultilist(Ytbmultilist addTo) {
        if (ytbmultilist == null) {
            ytbmultilist = new ArrayList<>();
        }
        ytbmultilist.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(ytbmultilist);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbMultiModuleaOpParam) {
            YtbMultiModuleaOpParam other = (YtbMultiModuleaOpParam) obj;
            return
                Objects.deepEquals(ytbmultilist, other.ytbmultilist);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ytbmultilist=" + ytbmultilist)
            .toString();
    }

    /**
     * Creates an instance of ytbMultiModuleaOpParam.
     */
    public YtbMultiModuleaOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}