/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte;

import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.globalsgrouping.Globals;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lspsstategrouping.LspsState;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.Tunnels;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of te.
 */
public interface Te extends Augmentable  {

    /**
     * Returns the attribute tunnels.
     *
     * @return tunnels value of tunnels
     */
    Tunnels tunnels();

    /**
     * Returns the attribute globals.
     *
     * @return globals value of globals
     */
    Globals globals();

    /**
     * Returns the attribute lspsState.
     *
     * @return lspsState value of lspsState
     */
    LspsState lspsState();

    /**
     * Sets the attribute tunnels.
     *
     * @param tunnels value of tunnels
     */
    void tunnels(Tunnels tunnels);

    /**
     * Sets the attribute globals.
     *
     * @param globals value of globals
     */
    void globals(Globals globals);

    /**
     * Sets the attribute lspsState.
     *
     * @param lspsState value of lspsState
     */
    void lspsState(LspsState lspsState);

}