/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.globalsgrouping;

import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups.NamedAdminGroups;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpaths.NamedExplicitPaths;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.NamedPathConstraints;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedsrlgs.NamedSrlgs;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of globals.
 */
public interface Globals extends Augmentable  {

    /**
     * Returns the attribute namedAdminGroups.
     *
     * @return namedAdminGroups value of namedAdminGroups
     */
    NamedAdminGroups namedAdminGroups();

    /**
     * Returns the attribute namedSrlgs.
     *
     * @return namedSrlgs value of namedSrlgs
     */
    NamedSrlgs namedSrlgs();

    /**
     * Returns the attribute namedExplicitPaths.
     *
     * @return namedExplicitPaths value of namedExplicitPaths
     */
    NamedExplicitPaths namedExplicitPaths();

    /**
     * Returns the attribute namedPathConstraints.
     *
     * @return namedPathConstraints value of namedPathConstraints
     */
    NamedPathConstraints namedPathConstraints();

    /**
     * Sets the attribute namedAdminGroups.
     *
     * @param namedAdminGroups value of namedAdminGroups
     */
    void namedAdminGroups(NamedAdminGroups namedAdminGroups);

    /**
     * Sets the attribute namedSrlgs.
     *
     * @param namedSrlgs value of namedSrlgs
     */
    void namedSrlgs(NamedSrlgs namedSrlgs);

    /**
     * Sets the attribute namedExplicitPaths.
     *
     * @param namedExplicitPaths value of namedExplicitPaths
     */
    void namedExplicitPaths(NamedExplicitPaths namedExplicitPaths);

    /**
     * Sets the attribute namedPathConstraints.
     *
     * @param namedPathConstraints value of namedPathConstraints
     */
    void namedPathConstraints(NamedPathConstraints namedPathConstraints);

}