/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedsrlgs;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedsrlgs.namedsrlgs.NamedSrlg;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of namedSrlgs.
 */
public interface NamedSrlgs extends Augmentable  {

    /**
     * Returns the attribute namedSrlg.
     *
     * @return namedSrlg list of namedSrlg
     */
    List<NamedSrlg> namedSrlg();

    /**
     * Sets the attribute namedSrlg.
     *
     * @param namedSrlg list of namedSrlg
     */
    void namedSrlg(List<NamedSrlg> namedSrlg);

    /**
     * Adds to the list of namedSrlg.
     *
     * @param addTo value of namedSrlg
     */
    void addToNamedSrlg(NamedSrlg addTo);

}