/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2psecondarypathpropertiesstate;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of lsp.
 */
public interface Lsp extends Augmentable  {

    /**
     * Identify the leaf of Lsp.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents source.
         */
        SOURCE(1),
        /**
         * Represents destination.
         */
        DESTINATION(2),
        /**
         * Represents tunnelId.
         */
        TUNNELID(3),
        /**
         * Represents lspId.
         */
        LSPID(4),
        /**
         * Represents extendedTunnelId.
         */
        EXTENDEDTUNNELID(5),
        /**
         * Represents type.
         */
        TYPE(6),
        /**
         * Represents active.
         */
        ACTIVE(7);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    Object source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    Object destination();

    /**
     * Returns the attribute tunnelId.
     *
     * @return tunnelId value of tunnelId
     */
    Object tunnelId();

    /**
     * Returns the attribute lspId.
     *
     * @return lspId value of lspId
     */
    Object lspId();

    /**
     * Returns the attribute extendedTunnelId.
     *
     * @return extendedTunnelId value of extendedTunnelId
     */
    Object extendedTunnelId();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Object type();

    /**
     * Returns the attribute active.
     *
     * @return active value of active
     */
    boolean active();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(Object source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(Object destination);

    /**
     * Sets the attribute tunnelId.
     *
     * @param tunnelId value of tunnelId
     */
    void tunnelId(Object tunnelId);

    /**
     * Sets the attribute lspId.
     *
     * @param lspId value of lspId
     */
    void lspId(Object lspId);

    /**
     * Sets the attribute extendedTunnelId.
     *
     * @param extendedTunnelId value of extendedTunnelId
     */
    void extendedTunnelId(Object extendedTunnelId);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Object type);

    /**
     * Sets the attribute active.
     *
     * @param active value of active
     */
    void active(boolean active);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}