/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.CandidateP2PsecondaryPath;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of candidateP2PsecondaryPaths.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCandidateP2PsecondaryPaths extends InnerModelObject implements CandidateP2PsecondaryPaths {
    protected List<CandidateP2PsecondaryPath> candidateP2PsecondaryPath;

    @Override
    public List<CandidateP2PsecondaryPath> candidateP2PsecondaryPath() {
        return candidateP2PsecondaryPath;
    }

    @Override
    public void candidateP2PsecondaryPath(List<CandidateP2PsecondaryPath> candidateP2PsecondaryPath) {
        this.candidateP2PsecondaryPath = candidateP2PsecondaryPath;
    }

    @Override
    public void addToCandidateP2PsecondaryPath(CandidateP2PsecondaryPath addTo) {
        if (candidateP2PsecondaryPath == null) {
            candidateP2PsecondaryPath = new ArrayList<>();
        }
        candidateP2PsecondaryPath.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(candidateP2PsecondaryPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCandidateP2PsecondaryPaths) {
            DefaultCandidateP2PsecondaryPaths other = (DefaultCandidateP2PsecondaryPaths) obj;
            return
                Objects.deepEquals(candidateP2PsecondaryPath, other.candidateP2PsecondaryPath);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("candidateP2PsecondaryPath=" + candidateP2PsecondaryPath)
            .toString();
    }


    /**
     * Creates an instance of defaultCandidateP2PsecondaryPaths.
     */
    public DefaultCandidateP2PsecondaryPaths() {
    }

}