/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels.Tunnel;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels.TunnelP2Mp;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of tunnels.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTunnels extends InnerModelObject implements Tunnels {
    protected List<Tunnel> tunnel;
    protected List<TunnelP2Mp> tunnelP2Mp;

    @Override
    public List<Tunnel> tunnel() {
        return tunnel;
    }

    @Override
    public List<TunnelP2Mp> tunnelP2Mp() {
        return tunnelP2Mp;
    }

    @Override
    public void tunnel(List<Tunnel> tunnel) {
        this.tunnel = tunnel;
    }

    @Override
    public void tunnelP2Mp(List<TunnelP2Mp> tunnelP2Mp) {
        this.tunnelP2Mp = tunnelP2Mp;
    }

    @Override
    public void addToTunnel(Tunnel addTo) {
        if (tunnel == null) {
            tunnel = new ArrayList<>();
        }
        tunnel.add(addTo);
    }


    @Override
    public void addToTunnelP2Mp(TunnelP2Mp addTo) {
        if (tunnelP2Mp == null) {
            tunnelP2Mp = new ArrayList<>();
        }
        tunnelP2Mp.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tunnel, tunnelP2Mp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnels) {
            DefaultTunnels other = (DefaultTunnels) obj;
            return
                Objects.deepEquals(tunnel, other.tunnel) &&
                Objects.deepEquals(tunnelP2Mp, other.tunnelP2Mp);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tunnel=" + tunnel)
            .add("tunnelP2Mp=" + tunnelP2Mp)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnels.
     */
    public DefaultTunnels() {
    }

}