/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionId;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of pushUpdate.
 */
public class DefaultPushUpdate extends InnerModelObject implements PushUpdate {
    protected SubscriptionId subscriptionId;
    protected DateAndTime timeOfUpdate;
    protected boolean updatesNotSent;
    protected String datastoreContentsString;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    @Override
    public DateAndTime timeOfUpdate() {
        return timeOfUpdate;
    }

    @Override
    public boolean updatesNotSent() {
        return updatesNotSent;
    }

    @Override
    public String datastoreContentsString() {
        return datastoreContentsString;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void subscriptionId(SubscriptionId subscriptionId) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONID.getLeafIndex());
        this.subscriptionId = subscriptionId;
    }

    @Override
    public void timeOfUpdate(DateAndTime timeOfUpdate) {
        valueLeafFlags.set(LeafIdentifier.TIMEOFUPDATE.getLeafIndex());
        this.timeOfUpdate = timeOfUpdate;
    }

    @Override
    public void updatesNotSent(boolean updatesNotSent) {
        valueLeafFlags.set(LeafIdentifier.UPDATESNOTSENT.getLeafIndex());
        this.updatesNotSent = updatesNotSent;
    }

    @Override
    public void datastoreContentsString(String datastoreContentsString) {
        valueLeafFlags.set(LeafIdentifier.DATASTORECONTENTSSTRING.getLeafIndex());
        this.datastoreContentsString = datastoreContentsString;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId, timeOfUpdate, updatesNotSent, datastoreContentsString, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPushUpdate) {
            DefaultPushUpdate other = (DefaultPushUpdate) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId) &&
                Objects.deepEquals(timeOfUpdate, other.timeOfUpdate) &&
                Objects.deepEquals(updatesNotSent, other.updatesNotSent) &&
                Objects.deepEquals(datastoreContentsString, other.datastoreContentsString) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionId=" + subscriptionId)
            .add("timeOfUpdate=" + timeOfUpdate)
            .add("updatesNotSent=" + updatesNotSent)
            .add("datastoreContentsString=" + datastoreContentsString)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultPushUpdate.
     */
    public DefaultPushUpdate() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}