/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onosproject.yang.compiler.datamodel.DefaultDenyAllExtension;
import org.onosproject.yang.compiler.datamodel.DefaultDenyWriteExtension;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangCommonInfo;
import org.onosproject.yang.compiler.datamodel.YangConfig;
import org.onosproject.yang.compiler.datamodel.YangDefault;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangIfFeatureHolder;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangMandatory;
import org.onosproject.yang.compiler.datamodel.YangMust;
import org.onosproject.yang.compiler.datamodel.YangMustHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangStatusType;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangUnits;
import org.onosproject.yang.compiler.datamodel.YangWhen;
import org.onosproject.yang.compiler.datamodel.YangWhenHolder;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.LeafContextUtil;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.LeafObjectType;
import org.onosproject.yang.model.LeafRestriction;
import org.onosproject.yang.model.LeafSchemaContext;
import org.onosproject.yang.model.LeafType;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.YangNamespace;

public abstract class YangLeaf
extends DefaultLocationInfo
implements YangCommonInfo,
Parsable,
Cloneable,
Serializable,
YangMustHolder,
YangIfFeatureHolder,
YangWhenHolder,
YangSchemaNode,
YangConfig,
YangUnits,
YangDefault,
YangMandatory,
LeafSchemaContext,
SchemaDataNode,
DefaultDenyWriteExtension,
DefaultDenyAllExtension {
    private static final long serialVersionUID = 806201635L;
    private YangSchemaNodeIdentifier yangSchemaNodeIdentifier;
    private boolean isConfig;
    private String description;
    private boolean isMandatory;
    private String reference;
    private YangStatusType status = YangStatusType.CURRENT;
    private String units;
    private YangType<?> dataType;
    private String defaultValueInString;
    private YangWhen when;
    private YangLeavesHolder containedIn;
    private List<YangMust> mustConstraintList = new LinkedList<YangMust>();
    private List<YangIfFeature> ifFeatureList = new LinkedList<YangIfFeature>();
    private YangLeaf referredLeaf;
    private boolean isKeyLeaf;
    private SchemaContext parentContext;
    private boolean defaultDenyWrite;
    private boolean defaultDenyAll;

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public void setMandatory(boolean isReq) {
        this.isMandatory = isReq;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public String getDefaultValueInString() {
        return this.defaultValueInString;
    }

    @Override
    public void setDefaultValueInString(String defaultValueInString) {
        this.defaultValueInString = defaultValueInString;
    }

    public YangType<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(YangType<?> dataType) {
        this.dataType = dataType;
    }

    @Override
    public boolean isEmptyDataType() {
        return DataModelUtils.validateEmptyDataType(this.dataType);
    }

    public YangLeavesHolder getContainedIn() {
        return this.containedIn;
    }

    public void setContainedIn(YangLeavesHolder containedIn) {
        this.containedIn = containedIn;
    }

    public YangLeaf clone() throws CloneNotSupportedException {
        YangLeaf cl = (YangLeaf)super.clone();
        cl.yangSchemaNodeIdentifier = this.yangSchemaNodeIdentifier.clone();
        return cl;
    }

    public YangLeaf cloneForDeviation() throws CloneNotSupportedException {
        YangLeaf cl = (YangLeaf)super.clone();
        return cl;
    }

    @Override
    public boolean getDefaultDenyWrite() {
        return this.defaultDenyWrite;
    }

    @Override
    public void setDefaultDenyWrite(boolean defaultDenyWrite) {
        this.defaultDenyWrite = defaultDenyWrite;
    }

    @Override
    public boolean getDefaultDenyAll() {
        return this.defaultDenyAll;
    }

    @Override
    public void setDefaultDenyAll(boolean defaultDenyAll) {
        this.defaultDenyAll = defaultDenyAll;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.LEAF_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        if (this.defaultValueInString != null && !this.defaultValueInString.isEmpty() && this.dataType != null) {
            this.dataType.isValidValue(this.defaultValueInString);
        }
    }

    @Override
    public List<YangMust> getListOfMust() {
        return this.mustConstraintList;
    }

    @Override
    public void setListOfMust(List<YangMust> mustConstraintList) {
        this.mustConstraintList = mustConstraintList;
    }

    @Override
    public void addMust(YangMust must) {
        if (this.getListOfMust() == null) {
            this.setListOfMust(new LinkedList<YangMust>());
        }
        this.getListOfMust().add(must);
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return this.ifFeatureList;
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        if (this.getIfFeatureList() == null) {
            this.setIfFeatureList(new LinkedList<YangIfFeature>());
        }
        this.getIfFeatureList().add(ifFeature);
    }

    @Override
    public YangSchemaNodeContextInfo getChildSchema(YangSchemaNodeIdentifier dataNodeIdentifier) throws DataModelException {
        throw new DataModelException("leaf cannot have any child schema nodes " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public void isValueValid(String value) throws DataModelException {
        this.getDataType().isValidValue(value);
    }

    @Override
    public int getMandatoryChildCount() throws DataModelException {
        throw new DataModelException("Leaf can't have child. " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChild(YangSchemaNodeIdentifier dataNodeIdentifier) {
        return null;
    }

    @Override
    public boolean isNotificationPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    @Override
    public boolean isRpcPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_SINGLE_INSTANCE_LEAF_NODE;
    }

    public void setLeafNameSpaceAndAddToParentSchemaMap(YangNamespace nameSpace) {
        this.setNameSpace(nameSpace);
        ((YangNode)((Object)this.getContainedIn())).processAdditionOfSchemaNodeToCurNodeMap(this.getName(), this.getNameSpace(), this);
    }

    @Override
    public YangSchemaNodeIdentifier getYangSchemaNodeIdentifier() {
        return this.yangSchemaNodeIdentifier;
    }

    public void setYangSchemaNodeIdentifier(YangSchemaNodeIdentifier yangSchemaNodeIdentifier) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier = yangSchemaNodeIdentifier;
    }

    @Override
    public String getName() {
        return this.yangSchemaNodeIdentifier.getName();
    }

    public void setName(String name) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setName(name);
    }

    @Override
    public YangNamespace getNameSpace() {
        return this.yangSchemaNodeIdentifier.getNameSpace();
    }

    public void setNameSpace(YangNamespace namespace) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setNameSpace(namespace);
    }

    @Override
    public YangSchemaNode getNotificationSchemaNode(String notificationNameInEnum) throws DataModelException {
        throw new DataModelException("Method called for schema node other then module/sub-module");
    }

    @Override
    public YangLeaf getReferredSchema() {
        return this.referredLeaf;
    }

    public void setReferredLeaf(YangLeaf leaf) {
        this.referredLeaf = leaf;
    }

    public boolean isKeyLeaf() {
        return this.isKeyLeaf;
    }

    public void setKeyLeaf(boolean keyLeaf) {
        this.isKeyLeaf = keyLeaf;
    }

    public DataNode.Type getType() {
        return DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE;
    }

    public SchemaId getSchemaId() {
        SchemaId schemaId = new SchemaId(this.getName(), this.getNameSpace().getModuleNamespace());
        return schemaId;
    }

    public LeafObjectType getLeafObjectType() {
        return DataModelUtils.getLeafTypeByDataType(this.dataType, this.dataType.getDataType());
    }

    public <T extends LeafRestriction> T getLeafRestrictions() {
        return null;
    }

    public Object fromString(String value) {
        return LeafContextUtil.getObject(this.dataType, value, this.dataType.getDataType());
    }

    public LeafType getLeafType(String v) {
        return LeafContextUtil.getLeafType(this.dataType, v, this.dataType.getDataType());
    }

    public YangNamespace getValueNamespace(String value) {
        return LeafContextUtil.getValueNamespace(this.dataType, value, this.dataType.getDataType());
    }

    public SchemaContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(SchemaContext sc) {
        this.parentContext = sc;
    }

    @Override
    public void setRootContext(SchemaContext context) {
        this.parentContext = context;
    }

    @Override
    public Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> getYsnContextInfoMap() {
        throw new IllegalArgumentException("This call is not valid for YANG leaf/leaf-list");
    }

    @Override
    public YangSchemaNode addSchema(YangSchemaNode containedSchema) throws IllegalArgumentException {
        throw new IllegalArgumentException("This call is not valid for YANG leaf/leaf-list");
    }
}

