/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.CompositeData;

public class DefaultCompositeData
implements CompositeData {
    private ResourceData data;
    private List<AnnotatedNodeInfo> annotationsInfo;

    protected DefaultCompositeData(Builder b) {
        this.data = b.data;
        this.annotationsInfo = b.annotationsInfo;
    }

    @Override
    public ResourceData resourceData() {
        return this.data;
    }

    @Override
    public List<AnnotatedNodeInfo> annotatedNodesInfo() {
        return this.annotationsInfo;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.annotationsInfo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCompositeData) {
            DefaultCompositeData that = (DefaultCompositeData)obj;
            return Objects.equals(this.data, that.data) && Objects.equals(this.annotationsInfo, that.annotationsInfo);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("data", (Object)this.data).add("annotationsInfo", this.annotationsInfo).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CompositeData.Builder {
        private ResourceData data;
        private List<AnnotatedNodeInfo> annotationsInfo = new LinkedList<AnnotatedNodeInfo>();

        protected Builder() {
        }

        @Override
        public Builder resourceData(ResourceData rd) {
            this.data = rd;
            return this;
        }

        @Override
        public Builder addAnnotatedNodeInfo(AnnotatedNodeInfo info) {
            this.annotationsInfo.add(info);
            return this;
        }

        @Override
        public CompositeData build() {
            return new DefaultCompositeData(this);
        }
    }
}

