/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.node.JsonNodeType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.serializers.json.DataNodeSiblingPositionType;
import org.onosproject.yang.serializers.json.DataNodeVisitor;
import org.onosproject.yang.serializers.json.JsonBuilder;

public class DataNodeJsonVisitor
implements DataNodeVisitor {
    private static final String COLON = ":";
    private JsonBuilder jsonBuilder;

    public DataNodeJsonVisitor(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    @Override
    public void enterDataNode(DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        String nodeName = this.getNodeNameWithNamespace(dataNode.key().schemaId());
        switch (dataNode.type()) {
            case SINGLE_INSTANCE_NODE: {
                this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.OBJECT);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                if (siblingType == DataNodeSiblingPositionType.FIRST_INSTANCE || siblingType == DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) {
                    this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.ARRAY);
                }
                this.jsonBuilder.addNodeTopHalf("", JsonNodeType.OBJECT);
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                this.jsonBuilder.addNodeWithValueTopHalf(nodeName, ((LeafNode)dataNode).value().toString());
                break;
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                if (siblingType == DataNodeSiblingPositionType.FIRST_INSTANCE || siblingType == DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) {
                    this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.ARRAY);
                }
                this.jsonBuilder.addValueToLeafListNode(((LeafNode)dataNode).value().toString());
                break;
            }
        }
    }

    private String getNodeNameWithNamespace(SchemaId schemaId) {
        String nodeName = schemaId.name();
        String nameSpace = schemaId.namespace();
        StringBuilder builder = new StringBuilder();
        builder.append(nodeName);
        if (nameSpace != null) {
            builder.append(COLON);
            builder.append(nameSpace);
        }
        return builder.toString();
    }

    @Override
    public void exitDataNode(DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        switch (dataNode.type()) {
            case SINGLE_INSTANCE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.OBJECT);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.OBJECT);
                if (siblingType != DataNodeSiblingPositionType.LAST_INSTANCE && siblingType != DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) break;
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.ARRAY);
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.STRING);
                break;
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.STRING);
                if (siblingType != DataNodeSiblingPositionType.LAST_INSTANCE && siblingType != DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) break;
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.ARRAY);
                break;
            }
        }
    }
}

