/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.serializers.json.DataNodeJsonVisitor;
import org.onosproject.yang.serializers.json.DataNodeSiblingPositionType;
import org.onosproject.yang.serializers.json.DataNodeVisitor;
import org.onosproject.yang.serializers.json.DefaultJsonBuilder;

public final class EncoderUtils {
    private EncoderUtils() {
    }

    public static ObjectNode convertDataNodeToJson(DataNode dataNode) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data node cannot be null");
        DefaultJsonBuilder jsonBuilder = new DefaultJsonBuilder();
        DataNodeJsonVisitor treeNodeListener = new DataNodeJsonVisitor(jsonBuilder);
        DataNodeSiblingPositionType siblingType = DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        EncoderUtils.walkDataNodeTree(treeNodeListener, dataNode, siblingType);
        ObjectNode resultData = jsonBuilder.getTreeNode();
        return resultData;
    }

    private static void walkDataNodeTree(DataNodeVisitor dataNodeVisitor, DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data tree cannot be null");
        Preconditions.checkNotNull((Object)dataNodeVisitor, (Object)"dataNodeVisitor cannot be null");
        dataNodeVisitor.enterDataNode(dataNode, siblingType);
        if (dataNode.type() == DataNode.Type.SINGLE_INSTANCE_NODE || dataNode.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
            EncoderUtils.walkChildNodeList(dataNodeVisitor, dataNode);
        }
        dataNodeVisitor.exitDataNode(dataNode, siblingType);
    }

    private static void walkChildNodeList(DataNodeVisitor dataNodeVisitor, DataNode dataNode) {
        if (dataNode.type() != DataNode.Type.SINGLE_INSTANCE_NODE && dataNode.type() != DataNode.Type.MULTI_INSTANCE_NODE) {
            return;
        }
        Map childrenList = ((InnerNode)dataNode).childNodes();
        if (childrenList == null || childrenList.isEmpty()) {
            return;
        }
        DataNodeSiblingPositionType prevChildType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        DataNodeSiblingPositionType currChildType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        Iterator it = childrenList.entrySet().iterator();
        DataNode currChild = (DataNode)it.next().getValue();
        DataNode nextChild = null;
        boolean lastChildNotProcessed = true;
        while (lastChildNotProcessed) {
            if (it.hasNext()) {
                nextChild = (DataNode)it.next().getValue();
            } else {
                lastChildNotProcessed = false;
                nextChild = null;
            }
            currChildType = EncoderUtils.getCurrentChildSiblingType(currChild, nextChild, prevChildType);
            EncoderUtils.walkDataNodeTree(dataNodeVisitor, currChild, currChildType);
            prevChildType = currChildType;
            currChild = nextChild;
        }
    }

    private static DataNodeSiblingPositionType getCurrentChildSiblingType(DataNode currChild, DataNode nextChild, DataNodeSiblingPositionType prevChildType) {
        if (currChild.type() != DataNode.Type.MULTI_INSTANCE_NODE && currChild.type() != DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            return DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        }
        DataNodeSiblingPositionType curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        switch (prevChildType) {
            case UNKNOWN_TYPE: {
                if (nextChild == null) {
                    curChildSiblingType = DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.FIRST_INSTANCE;
                break;
            }
            case NOT_MULTI_INSTANCE_NODE: 
            case LAST_INSTANCE: {
                curChildSiblingType = DataNodeSiblingPositionType.FIRST_INSTANCE;
                break;
            }
            case FIRST_INSTANCE: 
            case MIDDLE_INSTANCE: {
                if (nextChild != null && nextChild.key().schemaId().name().equals(currChild.key().schemaId().name())) {
                    curChildSiblingType = DataNodeSiblingPositionType.MIDDLE_INSTANCE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.LAST_INSTANCE;
                break;
            }
            default: {
                curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
            }
        }
        return curChildSiblingType;
    }
}

