/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Iterator;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.runtime.helperutils.SerializerHelper;
import org.onosproject.yang.serializers.json.JsonWalker;

public class DefaultJsonWalker
implements JsonWalker {
    private static final String COLON = ":";
    private DataNode.Builder dataNodeBuilder;

    public DefaultJsonWalker(DataNode.Builder dataNodeBuilder) {
        this.dataNodeBuilder = dataNodeBuilder;
    }

    @Override
    public void walkJsonNode(String fieldName, JsonNode jsonNode) {
        JsonNodeType nodeType = jsonNode.getNodeType();
        if (!jsonNode.isContainerNode()) {
            this.addLeafNodeToDataTree(fieldName, jsonNode);
            SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
            return;
        }
        if (jsonNode.isArray()) {
            if (this.isJsonNodeLeafList((ArrayNode)jsonNode)) {
                this.addLeafListNodeToDataTree(fieldName, (ArrayNode)jsonNode);
                SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
                return;
            }
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                this.addMultiInstanceNodeToDataTree(fieldName);
                this.walkJsonNode(null, element);
                SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
            }
            SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
            return;
        }
        if (fieldName != null) {
            this.addSingleInstanceNodeToDataTree(fieldName);
        }
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry currentChild = (Map.Entry)fields.next();
            String key = (String)currentChild.getKey();
            JsonNode value = (JsonNode)currentChild.getValue();
            this.walkJsonNode(key, value);
        }
        if (fieldName != null) {
            SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
        }
    }

    private void addDataNode(String fieldName, String value, DataNode.Type nodeType) {
        String nodeName = this.getLatterSegment(fieldName, COLON);
        String namespace = this.getPreSegment(fieldName, COLON);
        SerializerHelper.addDataNode((DataNode.Builder)this.dataNodeBuilder, (String)nodeName, (String)namespace, (String)value, (DataNode.Type)nodeType);
    }

    private void addNoneLeafDataNode(String fieldName, DataNode.Type nodeType) {
        this.addDataNode(fieldName, null, nodeType);
    }

    private void addLeafDataNode(String fieldName, String value, DataNode.Type nodeType) {
        this.addDataNode(fieldName, value, nodeType);
    }

    private void addSingleInstanceNodeToDataTree(String fieldName) {
        this.addNoneLeafDataNode(fieldName, DataNode.Type.SINGLE_INSTANCE_NODE);
    }

    private void addMultiInstanceNodeToDataTree(String fieldName) {
        this.addNoneLeafDataNode(fieldName, DataNode.Type.MULTI_INSTANCE_NODE);
    }

    private void addLeafNodeToDataTree(String fieldName, JsonNode jsonNode) {
        String value = jsonNode.asText();
        this.addLeafDataNode(fieldName, value, DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
    }

    private void addLeafListNodeToDataTree(String fieldName, ArrayNode jsonNode) {
        Iterator elements = jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            JsonNodeType eleType = element.getNodeType();
            if (eleType != JsonNodeType.STRING && eleType != JsonNodeType.NUMBER) continue;
            this.addLeafDataNode(fieldName, element.asText(), DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE);
            SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
        }
    }

    private boolean isJsonNodeLeafList(ArrayNode jsonNode) {
        if (!jsonNode.isArray()) {
            return false;
        }
        Iterator elements = jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            JsonNodeType eleType = element.getNodeType();
            if (eleType == JsonNodeType.STRING || eleType == JsonNodeType.NUMBER) continue;
            return false;
        }
        return true;
    }

    private String getPreSegment(String path, String splitChar) {
        int idx = path.indexOf(splitChar);
        if (idx == -1) {
            return null;
        }
        if (path.indexOf(splitChar, idx + 1) != -1) {
            return null;
        }
        return path.substring(0, idx);
    }

    private String getLatterSegment(String path, String splitChar) {
        int idx = path.indexOf(splitChar);
        if (idx == -1) {
            return path;
        }
        if (path.indexOf(splitChar, idx + 1) != -1) {
            return null;
        }
        return path.substring(idx + 1);
    }
}

