/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.DefaultCompositeData;
import org.onosproject.yang.runtime.DefaultCompositeStream;
import org.onosproject.yang.runtime.DefaultResourceData;
import org.onosproject.yang.runtime.YangSerializer;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.json.DecoderUtils;
import org.onosproject.yang.serializers.json.EncoderUtils;
import org.onosproject.yang.serializers.json.SerializerException;
import org.onosproject.yang.serializers.utils.SerializersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements YangSerializer {
    private static final String JSON_FORMAT = "JSON";
    private static final String ERROR_INFO = "JSON serializer decode failure";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public String supportsFormat() {
        return JSON_FORMAT;
    }

    public CompositeData decode(CompositeStream compositeStream, YangSerializerContext yangSerializerContext) {
        try {
            ResourceId.Builder rIdBuilder = SerializersUtil.convertUriToRid((String)compositeStream.resourceId(), (YangSerializerContext)yangSerializerContext);
            ObjectNode rootNode = null;
            if (compositeStream.resourceData() != null) {
                rootNode = (ObjectNode)this.mapper().readTree(compositeStream.resourceData());
            }
            DataNode dataNode = rIdBuilder != null ? DecoderUtils.convertJsonToDataNode(rootNode, rIdBuilder) : DecoderUtils.convertJsonToDataNode(rootNode, yangSerializerContext);
            ResourceData resourceData = DefaultResourceData.builder().addDataNode(dataNode).resourceId(rIdBuilder == null ? null : rIdBuilder.build()).build();
            return DefaultCompositeData.builder().resourceData(resourceData).build();
        }
        catch (JsonProcessingException e) {
            this.log.error("ERROR: JsonProcessingException {}", (Object)e.getMessage());
            this.log.debug("Exception in decode:", (Throwable)e);
            throw new SerializerException(ERROR_INFO);
        }
        catch (IOException ex) {
            this.log.error("ERROR: decode ", (Throwable)ex);
            throw new SerializerException(ERROR_INFO);
        }
    }

    public CompositeStream encode(CompositeData compositeData, YangSerializerContext yangSerializerContext) {
        Preconditions.checkNotNull((Object)compositeData, (Object)"compositeData cannot be null");
        String uriString = SerializersUtil.convertRidToUri((ResourceId)compositeData.resourceData().resourceId());
        InputStream inputStream = null;
        ObjectNode rootNode = null;
        if (compositeData.resourceData().dataNodes() != null) {
            rootNode = EncoderUtils.convertDataNodeToJson((DataNode)compositeData.resourceData().dataNodes().get(0));
        }
        if (rootNode != null) {
            inputStream = IOUtils.toInputStream((String)rootNode.toString());
        }
        return new DefaultCompositeStream(uriString, inputStream);
    }
}

