/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Set;
import org.onosproject.yang.serializers.json.JsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonBuilder
implements JsonBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private StringBuilder treeString;
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String QUOTE = "\"";

    public DefaultJsonBuilder(String rootName) {
        Preconditions.checkNotNull((Object)rootName);
        this.treeString = new StringBuilder(rootName);
    }

    public DefaultJsonBuilder() {
        this.treeString = new StringBuilder();
    }

    @Override
    public void addNodeTopHalf(String nodeName, JsonNodeType nodeType) {
        this.appendField(nodeName);
        switch (nodeType) {
            case OBJECT: {
                this.treeString.append(LEFT_BRACE);
                break;
            }
            case ARRAY: {
                this.treeString.append(LEFT_BRACKET);
                break;
            }
            default: {
                this.log.error("Unknown support type {} for this method.", (Object)nodeType);
            }
        }
    }

    @Override
    public void addNodeWithValueTopHalf(String nodeName, String value) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            return;
        }
        this.appendField(nodeName);
        if (value.isEmpty()) {
            return;
        }
        this.treeString.append(QUOTE);
        this.treeString.append(value);
        this.treeString.append(QUOTE);
        this.treeString.append(COMMA);
    }

    @Override
    public void addNodeWithSetTopHalf(String nodeName, Set<String> sets) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            return;
        }
        this.appendField(nodeName);
        this.treeString.append(LEFT_BRACKET);
        for (String el : sets) {
            this.treeString.append(QUOTE);
            this.treeString.append(el);
            this.treeString.append(QUOTE);
            this.treeString.append(COMMA);
        }
    }

    @Override
    public void addValueToLeafListNode(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return;
        }
        this.treeString.append(QUOTE);
        this.treeString.append(value);
        this.treeString.append(QUOTE);
        this.treeString.append(COMMA);
    }

    @Override
    public void addNodeBottomHalf(JsonNodeType nodeType) {
        switch (nodeType) {
            case OBJECT: {
                this.removeCommaIfExist();
                this.treeString.append(RIGHT_BRACE);
                this.treeString.append(COMMA);
                break;
            }
            case ARRAY: {
                this.removeCommaIfExist();
                this.treeString.append(RIGHT_BRACKET);
                this.treeString.append(COMMA);
                break;
            }
            case BINARY: 
            case BOOLEAN: 
            case MISSING: 
            case NULL: 
            case NUMBER: 
            case POJO: 
            case STRING: {
                break;
            }
            default: {
                this.log.info("Unknown json node type {}", (Object)nodeType);
            }
        }
    }

    @Override
    public String getTreeString() {
        this.removeCommaIfExist();
        this.removeFirstFieldNameIfExist();
        return this.treeString.toString();
    }

    private void removeFirstFieldNameIfExist() {
        int index1 = this.treeString.indexOf(LEFT_BRACE);
        int index2 = this.treeString.indexOf(LEFT_BRACKET);
        if (index1 < 0 && index2 < 0) {
            return;
        }
        int index = index1 < 0 ? index2 : (index2 < 0 ? index1 : (index1 < index2 ? index1 : index2));
        this.treeString.delete(0, index);
    }

    @Override
    public ObjectNode getTreeNode() {
        ObjectNode node = null;
        try {
            ObjectMapper m = new ObjectMapper();
            m.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            node = (ObjectNode)m.readTree(this.getTreeString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return node;
    }

    @Override
    public void removeExtraTerminator() {
        this.removeCommaIfExist();
    }

    private void appendField(String fieldName) {
        if (fieldName != null && !fieldName.isEmpty()) {
            this.treeString.append(QUOTE);
            this.treeString.append(fieldName);
            this.treeString.append(QUOTE);
            this.treeString.append(COLON);
        }
    }

    private void removeCommaIfExist() {
        if (this.treeString.charAt(this.treeString.length() - 1) == COMMA.charAt(0)) {
            this.treeString.deleteCharAt(this.treeString.length() - 1);
        }
    }
}

