/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.json.DataNodeJsonVisitor;
import org.onosproject.yang.serializers.json.DataNodeSiblingPositionType;
import org.onosproject.yang.serializers.json.DataNodeVisitor;
import org.onosproject.yang.serializers.json.DefaultJsonBuilder;

public final class EncoderUtils {
    private EncoderUtils() {
    }

    public static ObjectNode convertDataNodeToJson(DataNode dataNode, YangSerializerContext context) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data node cannot be null");
        DefaultJsonBuilder jsonBuilder = new DefaultJsonBuilder();
        DataNodeJsonVisitor treeNodeListener = new DataNodeJsonVisitor(jsonBuilder, context);
        DataNodeSiblingPositionType siblingType = DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        EncoderUtils.walkDataNodeTree(treeNodeListener, dataNode, siblingType);
        jsonBuilder.removeExtraTerminator();
        ObjectNode resultData = jsonBuilder.getTreeNode();
        return resultData;
    }

    private static void walkDataNodeTree(DataNodeVisitor dataNodeVisitor, DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data tree cannot be null");
        Preconditions.checkNotNull((Object)dataNodeVisitor, (Object)"dataNodeVisitor cannot be null");
        dataNodeVisitor.enterDataNode(dataNode, siblingType);
        if (dataNode.type() == DataNode.Type.SINGLE_INSTANCE_NODE || dataNode.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
            EncoderUtils.walkChildNodeList(dataNodeVisitor, dataNode);
        }
        dataNodeVisitor.exitDataNode(dataNode, siblingType);
    }

    private static void walkChildNodeList(DataNodeVisitor dataNodeVisitor, DataNode dataNode) {
        if (dataNode.type() != DataNode.Type.SINGLE_INSTANCE_NODE && dataNode.type() != DataNode.Type.MULTI_INSTANCE_NODE) {
            return;
        }
        Map childrenList = ((InnerNode)dataNode).childNodes();
        if (childrenList == null || childrenList.isEmpty()) {
            return;
        }
        DataNodeSiblingPositionType prevChildType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        DataNodeSiblingPositionType currChildType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        List<DataNode> sortedChildList = EncoderUtils.sortChildrenList(childrenList);
        Preconditions.checkNotNull(sortedChildList, (Object)"sorted children list cannot be null");
        Iterator<DataNode> it = sortedChildList.iterator();
        DataNode currChild = it.next();
        DataNode nextChild = null;
        boolean lastChildNotProcessed = true;
        while (lastChildNotProcessed) {
            if (it.hasNext()) {
                nextChild = it.next();
            } else {
                lastChildNotProcessed = false;
                nextChild = null;
            }
            currChildType = EncoderUtils.getCurrentChildSiblingType(currChild, nextChild, prevChildType);
            EncoderUtils.walkDataNodeTree(dataNodeVisitor, currChild, currChildType);
            prevChildType = currChildType;
            currChild = nextChild;
        }
    }

    private static DataNodeSiblingPositionType getCurrentChildSiblingType(DataNode currChild, DataNode nextChild, DataNodeSiblingPositionType prevChildType) {
        if (currChild.type() != DataNode.Type.MULTI_INSTANCE_NODE && currChild.type() != DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            return DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        }
        DataNodeSiblingPositionType curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        switch (prevChildType) {
            case UNKNOWN_TYPE: 
            case LAST_INSTANCE: 
            case NOT_MULTI_INSTANCE_NODE: {
                if (nextChild == null || !nextChild.key().schemaId().name().equals(currChild.key().schemaId().name())) {
                    curChildSiblingType = DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.FIRST_INSTANCE;
                break;
            }
            case FIRST_INSTANCE: 
            case MIDDLE_INSTANCE: {
                if (nextChild != null && nextChild.key().schemaId().name().equals(currChild.key().schemaId().name())) {
                    curChildSiblingType = DataNodeSiblingPositionType.MIDDLE_INSTANCE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.LAST_INSTANCE;
                break;
            }
            default: {
                curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
            }
        }
        return curChildSiblingType;
    }

    private static List<DataNode> sortChildrenList(Map<NodeKey, DataNode> childrenList) {
        if (childrenList == null || childrenList.isEmpty()) {
            return null;
        }
        ArrayList<DataNode> sortedList = new ArrayList<DataNode>();
        HashMap<String, ArrayList<DataNode>> groupedBucket = new HashMap<String, ArrayList<DataNode>>();
        Iterator<Map.Entry<NodeKey, DataNode>> it = childrenList.entrySet().iterator();
        while (it.hasNext()) {
            DataNode dataNode = it.next().getValue();
            String nodeName = dataNode.key().schemaId().name();
            ArrayList<DataNode> group = (ArrayList<DataNode>)groupedBucket.get(nodeName);
            if (group == null) {
                group = new ArrayList<DataNode>();
                groupedBucket.put(nodeName, group);
            }
            group.add(dataNode);
        }
        for (Map.Entry entry : groupedBucket.entrySet()) {
            sortedList.addAll((Collection)entry.getValue());
        }
        return sortedList;
    }
}

