/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.Device;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.List1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of demo1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class Demo1OpParam extends InnerModelObject implements Demo1 {
    protected Device device;
    protected List<List1> list1;

    @Override
    public Device device() {
        return device;
    }

    @Override
    public List<List1> list1() {
        return list1;
    }

    @Override
    public void device(Device device) {
        this.device = device;
    }

    @Override
    public void list1(List<List1> list1) {
        this.list1 = list1;
    }

    @Override
    public void addToList1(List1 addTo) {
        if (list1 == null) {
            list1 = new ArrayList<>();
        }
        list1.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(device, list1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Demo1OpParam) {
            Demo1OpParam other = (Demo1OpParam) obj;
            return
                Objects.equals(device, other.device) &&
                Objects.equals(list1, other.list1);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("device=" + device)
            .add("list1=" + list1)
            .toString();
    }

    /**
     * Creates an instance of demo1OpParam.
     */
    public Demo1OpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}