/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715.demo1;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of list1.
 */
public class List1Keys implements KeyInfo<DefaultList1> {
    protected String leaf1;
    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    public String leaf1() {
        return leaf1;
    }

    /**
     * Sets the value to attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    public void leaf1(String leaf1) {
        this.leaf1 = leaf1;
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof List1Keys) {
            List1Keys other = (List1Keys) obj;
            return
                Objects.equals(leaf1, other.leaf1);
        }
        return false;
    }
}