/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1.C2;
import org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1.L1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of top1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTop1 extends InnerModelObject implements Top1 {
    protected List<L1> l1;
    protected C2 c2;

    @Override
    public List<L1> l1() {
        return l1;
    }

    @Override
    public C2 c2() {
        return c2;
    }

    @Override
    public void l1(List<L1> l1) {
        this.l1 = l1;
    }

    @Override
    public void c2(C2 c2) {
        this.c2 = c2;
    }

    @Override
    public void addToL1(L1 addTo) {
        if (l1 == null) {
            l1 = new ArrayList<>();
        }
        l1.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(l1, c2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTop1) {
            DefaultTop1 other = (DefaultTop1) obj;
            return
                Objects.equals(l1, other.l1) &&
                Objects.equals(c2, other.c2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("l1=" + l1)
            .add("c2=" + c2)
            .toString();
    }


    /**
     * Creates an instance of defaultTop1.
     */
    public DefaultTop1() {
    }

}