/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1;

import java.lang.String;
import java.lang.String;
import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of l1.
 */
public class L1Keys implements KeyInfo<DefaultL1> {
    protected String k1;
    protected String k2;
    protected String k3;
    /**
     * Returns the attribute k1.
     *
     * @return k1 value of k1
     */
    public String k1() {
        return k1;
    }

    /**
     * Sets the value to attribute k1.
     *
     * @param k1 value of k1
     */
    public void k1(String k1) {
        this.k1 = k1;
    }

    /**
     * Returns the attribute k2.
     *
     * @return k2 value of k2
     */
    public String k2() {
        return k2;
    }

    /**
     * Sets the value to attribute k2.
     *
     * @param k2 value of k2
     */
    public void k2(String k2) {
        this.k2 = k2;
    }

    /**
     * Returns the attribute k3.
     *
     * @return k3 value of k3
     */
    public String k3() {
        return k3;
    }

    /**
     * Sets the value to attribute k3.
     *
     * @param k3 value of k3
     */
    public void k3(String k3) {
        this.k3 = k3;
    }


    @Override
    public int hashCode() {
        return Objects.hash(k1, k2, k3);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof L1Keys) {
            L1Keys other = (L1Keys) obj;
            return
                Objects.equals(k1, other.k1) &&
                Objects.equals(k2, other.k2) &&
                Objects.equals(k3, other.k3);
        }
        return false;
    }
}