/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of device.
 */
public class DeviceKeys implements KeyInfo<DefaultDevice> {
    protected String deviceid;
    /**
     * Returns the attribute deviceid.
     *
     * @return deviceid value of deviceid
     */
    public String deviceid() {
        return deviceid;
    }

    /**
     * Sets the value to attribute deviceid.
     *
     * @param deviceid value of deviceid
     */
    public void deviceid(String deviceid) {
        this.deviceid = deviceid;
    }


    @Override
    public int hashCode() {
        return Objects.hash(deviceid);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceKeys) {
            DeviceKeys other = (DeviceKeys) obj;
            return
                Objects.deepEquals(deviceid, other.deviceid);
        }
        return false;
    }
}