/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist;

import java.util.List;
import org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1.C2;
import org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1.L1;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of top1.
 */
public interface Top1 extends Augmentable  {

    /**
     * Returns the attribute l1.
     *
     * @return l1 list of l1
     */
    List<L1> l1();

    /**
     * Returns the attribute c2.
     *
     * @return c2 value of c2
     */
    C2 c2();

    /**
     * Sets the attribute l1.
     *
     * @param l1 list of l1
     */
    void l1(List<L1> l1);

    /**
     * Sets the attribute c2.
     *
     * @param c2 value of c2
     */
    void c2(C2 c2);

    /**
     * Adds to the list of l1.
     *
     * @param addTo value of l1
     */
    void addToL1(L1 addTo);

}