/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of c2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultC2 extends InnerModelObject implements C2 {
    protected List<String> leaflist1;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<String> leaflist1() {
        return leaflist1;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaflist1(List<String> leaflist1) {
        valueLeafFlags.set(LeafIdentifier.LEAFLIST1.getLeafIndex());
        this.leaflist1 = leaflist1;
    }

    @Override
    public void addToLeaflist1(String addTo) {
        if (leaflist1 == null) {
            leaflist1 = new ArrayList<>();
        }
        leaflist1.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaflist1, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultC2) {
            DefaultC2 other = (DefaultC2) obj;
            return
                Objects.deepEquals(leaflist1, other.leaflist1) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaflist1=" + leaflist1)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultC2.
     */
    public DefaultC2() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}