/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.node.JsonNodeType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.json.DataNodeSiblingPositionType;
import org.onosproject.yang.serializers.json.DataNodeVisitor;
import org.onosproject.yang.serializers.json.JsonBuilder;

public class DataNodeJsonVisitor
implements DataNodeVisitor {
    private static final String COLON = ":";
    private JsonBuilder jsonBuilder;
    private YangSerializerContext jsonSerializerContext;

    public DataNodeJsonVisitor(JsonBuilder jb, YangSerializerContext context) {
        this.jsonBuilder = jb;
        this.jsonSerializerContext = context;
    }

    @Override
    public void enterDataNode(DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        String nodeName = this.getNodeName(dataNode);
        String valNamespace = null;
        switch (dataNode.type()) {
            case SINGLE_INSTANCE_NODE: {
                this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.OBJECT);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                if (siblingType == DataNodeSiblingPositionType.FIRST_INSTANCE || siblingType == DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) {
                    this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.ARRAY);
                }
                this.jsonBuilder.addNodeTopHalf("", JsonNodeType.OBJECT);
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                LeafNode sLeafNode = (LeafNode)dataNode;
                if (sLeafNode.valueNamespace() != null) {
                    valNamespace = SerializerHelper.getModuleNameFromNameSpace((YangSerializerContext)this.jsonSerializerContext, (String)sLeafNode.valueNamespace());
                }
                this.jsonBuilder.addNodeWithValueTopHalf(nodeName, sLeafNode.asString(), valNamespace, sLeafNode.leafType());
                break;
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                LeafNode mLeafNode;
                if (siblingType == DataNodeSiblingPositionType.FIRST_INSTANCE || siblingType == DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) {
                    this.jsonBuilder.addNodeTopHalf(nodeName, JsonNodeType.ARRAY);
                }
                if ((mLeafNode = (LeafNode)dataNode).valueNamespace() != null) {
                    valNamespace = SerializerHelper.getModuleNameFromNameSpace((YangSerializerContext)this.jsonSerializerContext, (String)mLeafNode.valueNamespace());
                }
                this.jsonBuilder.addValueToLeafListNode(mLeafNode.asString(), valNamespace, mLeafNode.leafType());
                break;
            }
        }
        this.jsonBuilder.pushModuleName(this.getModuleNameFromDataNode(dataNode));
    }

    private String getModuleNameFromDataNode(DataNode dataNode) {
        String nameSpace = dataNode.key().schemaId().namespace();
        return SerializerHelper.getModuleNameFromNameSpace((YangSerializerContext)this.jsonSerializerContext, (String)nameSpace);
    }

    private String getNodeName(DataNode dataNode) {
        SchemaId schemaId = dataNode.key().schemaId();
        String nodeName = schemaId.name();
        String moduleName = this.getModuleNameFromDataNode(dataNode);
        StringBuilder builder = new StringBuilder();
        if (moduleName != null && !moduleName.equals(this.jsonBuilder.subTreeModuleName())) {
            builder.append(moduleName);
            builder.append(COLON);
        }
        builder.append(nodeName);
        return builder.toString();
    }

    @Override
    public void exitDataNode(DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        switch (dataNode.type()) {
            case SINGLE_INSTANCE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.OBJECT);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.OBJECT);
                if (siblingType != DataNodeSiblingPositionType.LAST_INSTANCE && siblingType != DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) break;
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.ARRAY);
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.STRING);
                break;
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.STRING);
                if (siblingType != DataNodeSiblingPositionType.LAST_INSTANCE && siblingType != DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE) break;
                this.jsonBuilder.addNodeBottomHalf(JsonNodeType.ARRAY);
                break;
            }
        }
        this.jsonBuilder.popModuleName();
    }
}

