/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of c2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultC2 extends InnerModelObject implements C2 {
    protected byte leaf1;
    protected short leaf2;
    protected int leaf3;
    protected short leaf4;
    protected int leaf5;
    protected long leaf6;
    protected long leaf7;
    protected BigInteger leaf8;
    protected boolean leaf9;
    protected BigDecimal leaf10;
    protected List<String> leaflist1;
    protected List<Byte> ll1;
    protected List<Short> ll2;
    protected List<Integer> ll3;
    protected List<Short> ll4;
    protected List<Integer> ll5;
    protected List<Long> ll6;
    protected List<Long> ll7;
    protected List<BigInteger> ll8;
    protected List<Boolean> ll9;
    protected List<BigDecimal> ll10;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public byte leaf1() {
        return leaf1;
    }

    @Override
    public short leaf2() {
        return leaf2;
    }

    @Override
    public int leaf3() {
        return leaf3;
    }

    @Override
    public short leaf4() {
        return leaf4;
    }

    @Override
    public int leaf5() {
        return leaf5;
    }

    @Override
    public long leaf6() {
        return leaf6;
    }

    @Override
    public long leaf7() {
        return leaf7;
    }

    @Override
    public BigInteger leaf8() {
        return leaf8;
    }

    @Override
    public boolean leaf9() {
        return leaf9;
    }

    @Override
    public BigDecimal leaf10() {
        return leaf10;
    }

    @Override
    public List<String> leaflist1() {
        return leaflist1;
    }

    @Override
    public List<Byte> ll1() {
        return ll1;
    }

    @Override
    public List<Short> ll2() {
        return ll2;
    }

    @Override
    public List<Integer> ll3() {
        return ll3;
    }

    @Override
    public List<Short> ll4() {
        return ll4;
    }

    @Override
    public List<Integer> ll5() {
        return ll5;
    }

    @Override
    public List<Long> ll6() {
        return ll6;
    }

    @Override
    public List<Long> ll7() {
        return ll7;
    }

    @Override
    public List<BigInteger> ll8() {
        return ll8;
    }

    @Override
    public List<Boolean> ll9() {
        return ll9;
    }

    @Override
    public List<BigDecimal> ll10() {
        return ll10;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf1(byte leaf1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1.getLeafIndex());
        this.leaf1 = leaf1;
    }

    @Override
    public void leaf2(short leaf2) {
        valueLeafFlags.set(LeafIdentifier.LEAF2.getLeafIndex());
        this.leaf2 = leaf2;
    }

    @Override
    public void leaf3(int leaf3) {
        valueLeafFlags.set(LeafIdentifier.LEAF3.getLeafIndex());
        this.leaf3 = leaf3;
    }

    @Override
    public void leaf4(short leaf4) {
        valueLeafFlags.set(LeafIdentifier.LEAF4.getLeafIndex());
        this.leaf4 = leaf4;
    }

    @Override
    public void leaf5(int leaf5) {
        valueLeafFlags.set(LeafIdentifier.LEAF5.getLeafIndex());
        this.leaf5 = leaf5;
    }

    @Override
    public void leaf6(long leaf6) {
        valueLeafFlags.set(LeafIdentifier.LEAF6.getLeafIndex());
        this.leaf6 = leaf6;
    }

    @Override
    public void leaf7(long leaf7) {
        valueLeafFlags.set(LeafIdentifier.LEAF7.getLeafIndex());
        this.leaf7 = leaf7;
    }

    @Override
    public void leaf8(BigInteger leaf8) {
        valueLeafFlags.set(LeafIdentifier.LEAF8.getLeafIndex());
        this.leaf8 = leaf8;
    }

    @Override
    public void leaf9(boolean leaf9) {
        valueLeafFlags.set(LeafIdentifier.LEAF9.getLeafIndex());
        this.leaf9 = leaf9;
    }

    @Override
    public void leaf10(BigDecimal leaf10) {
        valueLeafFlags.set(LeafIdentifier.LEAF10.getLeafIndex());
        this.leaf10 = leaf10;
    }

    @Override
    public void leaflist1(List<String> leaflist1) {
        valueLeafFlags.set(LeafIdentifier.LEAFLIST1.getLeafIndex());
        this.leaflist1 = leaflist1;
    }

    @Override
    public void ll1(List<Byte> ll1) {
        valueLeafFlags.set(LeafIdentifier.LL1.getLeafIndex());
        this.ll1 = ll1;
    }

    @Override
    public void ll2(List<Short> ll2) {
        valueLeafFlags.set(LeafIdentifier.LL2.getLeafIndex());
        this.ll2 = ll2;
    }

    @Override
    public void ll3(List<Integer> ll3) {
        valueLeafFlags.set(LeafIdentifier.LL3.getLeafIndex());
        this.ll3 = ll3;
    }

    @Override
    public void ll4(List<Short> ll4) {
        valueLeafFlags.set(LeafIdentifier.LL4.getLeafIndex());
        this.ll4 = ll4;
    }

    @Override
    public void ll5(List<Integer> ll5) {
        valueLeafFlags.set(LeafIdentifier.LL5.getLeafIndex());
        this.ll5 = ll5;
    }

    @Override
    public void ll6(List<Long> ll6) {
        valueLeafFlags.set(LeafIdentifier.LL6.getLeafIndex());
        this.ll6 = ll6;
    }

    @Override
    public void ll7(List<Long> ll7) {
        valueLeafFlags.set(LeafIdentifier.LL7.getLeafIndex());
        this.ll7 = ll7;
    }

    @Override
    public void ll8(List<BigInteger> ll8) {
        valueLeafFlags.set(LeafIdentifier.LL8.getLeafIndex());
        this.ll8 = ll8;
    }

    @Override
    public void ll9(List<Boolean> ll9) {
        valueLeafFlags.set(LeafIdentifier.LL9.getLeafIndex());
        this.ll9 = ll9;
    }

    @Override
    public void ll10(List<BigDecimal> ll10) {
        valueLeafFlags.set(LeafIdentifier.LL10.getLeafIndex());
        this.ll10 = ll10;
    }

    @Override
    public void addToLeaflist1(String addTo) {
        if (leaflist1 == null) {
            leaflist1 = new ArrayList<>();
        }
        leaflist1.add(addTo);
    }


    @Override
    public void addToLl1(Byte addTo) {
        if (ll1 == null) {
            ll1 = new ArrayList<>();
        }
        ll1.add(addTo);
    }


    @Override
    public void addToLl2(Short addTo) {
        if (ll2 == null) {
            ll2 = new ArrayList<>();
        }
        ll2.add(addTo);
    }


    @Override
    public void addToLl3(Integer addTo) {
        if (ll3 == null) {
            ll3 = new ArrayList<>();
        }
        ll3.add(addTo);
    }


    @Override
    public void addToLl4(Short addTo) {
        if (ll4 == null) {
            ll4 = new ArrayList<>();
        }
        ll4.add(addTo);
    }


    @Override
    public void addToLl5(Integer addTo) {
        if (ll5 == null) {
            ll5 = new ArrayList<>();
        }
        ll5.add(addTo);
    }


    @Override
    public void addToLl6(Long addTo) {
        if (ll6 == null) {
            ll6 = new ArrayList<>();
        }
        ll6.add(addTo);
    }


    @Override
    public void addToLl7(Long addTo) {
        if (ll7 == null) {
            ll7 = new ArrayList<>();
        }
        ll7.add(addTo);
    }


    @Override
    public void addToLl8(BigInteger addTo) {
        if (ll8 == null) {
            ll8 = new ArrayList<>();
        }
        ll8.add(addTo);
    }


    @Override
    public void addToLl9(Boolean addTo) {
        if (ll9 == null) {
            ll9 = new ArrayList<>();
        }
        ll9.add(addTo);
    }


    @Override
    public void addToLl10(BigDecimal addTo) {
        if (ll10 == null) {
            ll10 = new ArrayList<>();
        }
        ll10.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1, leaf2, leaf3, leaf4, leaf5, leaf6, leaf7, leaf8, leaf9, leaf10, leaflist1, ll1, ll2, ll3, ll4, ll5, ll6, ll7, ll8, ll9, ll10, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultC2) {
            DefaultC2 other = (DefaultC2) obj;
            return
                Objects.deepEquals(leaf1, other.leaf1) &&
                Objects.deepEquals(leaf2, other.leaf2) &&
                Objects.deepEquals(leaf3, other.leaf3) &&
                Objects.deepEquals(leaf4, other.leaf4) &&
                Objects.deepEquals(leaf5, other.leaf5) &&
                Objects.deepEquals(leaf6, other.leaf6) &&
                Objects.deepEquals(leaf7, other.leaf7) &&
                Objects.deepEquals(leaf8, other.leaf8) &&
                Objects.deepEquals(leaf9, other.leaf9) &&
                Objects.deepEquals(leaf10, other.leaf10) &&
                Objects.deepEquals(leaflist1, other.leaflist1) &&
                Objects.deepEquals(ll1, other.ll1) &&
                Objects.deepEquals(ll2, other.ll2) &&
                Objects.deepEquals(ll3, other.ll3) &&
                Objects.deepEquals(ll4, other.ll4) &&
                Objects.deepEquals(ll5, other.ll5) &&
                Objects.deepEquals(ll6, other.ll6) &&
                Objects.deepEquals(ll7, other.ll7) &&
                Objects.deepEquals(ll8, other.ll8) &&
                Objects.deepEquals(ll9, other.ll9) &&
                Objects.deepEquals(ll10, other.ll10) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1=" + leaf1)
            .add("leaf2=" + leaf2)
            .add("leaf3=" + leaf3)
            .add("leaf4=" + leaf4)
            .add("leaf5=" + leaf5)
            .add("leaf6=" + leaf6)
            .add("leaf7=" + leaf7)
            .add("leaf8=" + leaf8)
            .add("leaf9=" + leaf9)
            .add("leaf10=" + leaf10)
            .add("leaflist1=" + leaflist1)
            .add("ll1=" + ll1)
            .add("ll2=" + ll2)
            .add("ll3=" + ll3)
            .add("ll4=" + ll4)
            .add("ll5=" + ll5)
            .add("ll6=" + ll6)
            .add("ll7=" + ll7)
            .add("ll8=" + ll8)
            .add("ll9=" + ll9)
            .add("ll10=" + ll10)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultC2.
     */
    public DefaultC2() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}