/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715;

import java.util.List;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.Device;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.List1;

/**
 * Abstraction of an entity which represents the functionality of demo1.
 */
public interface Demo1 {

    /**
     * Returns the attribute device.
     *
     * @return device value of device
     */
    Device device();

    /**
     * Returns the attribute list1.
     *
     * @return list1 list of list1
     */
    List<List1> list1();

    /**
     * Sets the attribute device.
     *
     * @param device value of device
     */
    void device(Device device);

    /**
     * Sets the attribute list1.
     *
     * @param list1 list of list1
     */
    void list1(List<List1> list1);

    /**
     * Adds to the list of list1.
     *
     * @param addTo value of list1
     */
    void addToList1(List1 addTo);

}