/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Iterator;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.serializers.json.JsonWalker;
import org.onosproject.yang.serializers.utils.SerializersUtil;

public class DefaultJsonWalker
implements JsonWalker {
    private static final String COLON = ":";
    private DataNode.Builder dataNodeBuilder;

    public DefaultJsonWalker(DataNode.Builder db) {
        this.dataNodeBuilder = db;
    }

    public DataNode.Builder rootBuilder() {
        return this.dataNodeBuilder;
    }

    @Override
    public void walkJsonNode(String fieldName, JsonNode jsonNode) {
        if (!jsonNode.isContainerNode()) {
            this.addLeafNodeToDataTree(fieldName, jsonNode);
            if (this.dataNodeBuilder.parent() != null) {
                this.dataNodeBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
            }
            return;
        }
        if (jsonNode.isArray()) {
            if (this.isJsonNodeLeafList((ArrayNode)jsonNode)) {
                this.addLeafListNodeToDataTree(fieldName, (ArrayNode)jsonNode);
                return;
            }
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                this.addMultiInstanceNodeToDataTree(fieldName);
                this.walkJsonNode(null, element);
                if (this.dataNodeBuilder.parent() == null) continue;
                this.dataNodeBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
            }
            return;
        }
        if (fieldName != null) {
            this.addSingleInstanceNodeToDataTree(fieldName);
        }
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry currentChild = (Map.Entry)fields.next();
            String key = (String)currentChild.getKey();
            JsonNode value = (JsonNode)currentChild.getValue();
            this.walkJsonNode(key, value);
        }
        if (fieldName != null && this.dataNodeBuilder.parent() != null) {
            this.dataNodeBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
        }
    }

    private void addDataNode(String fieldName, String value, String valNamespace, DataNode.Type nodeType) {
        String nodeName = SerializersUtil.getLatterSegment((String)fieldName, (String)COLON);
        String namespace = SerializersUtil.getPreSegment((String)fieldName, (String)COLON);
        this.dataNodeBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dataNodeBuilder, (String)nodeName, (String)namespace, (String)value, (String)valNamespace, (DataNode.Type)nodeType);
    }

    private void addNoneLeafDataNode(String fieldName, DataNode.Type nodeType) {
        this.addDataNode(fieldName, null, null, nodeType);
    }

    private void addLeafDataNode(String fieldName, String value, DataNode.Type nodeType) {
        String actVal;
        String valNamespace = null;
        if (value != null) {
            actVal = SerializersUtil.getLatterSegment((String)value, (String)COLON);
            valNamespace = SerializersUtil.getPreSegment((String)value, (String)COLON);
        } else {
            actVal = value;
        }
        this.addDataNode(fieldName, actVal, valNamespace, nodeType);
    }

    private void addSingleInstanceNodeToDataTree(String fieldName) {
        this.addNoneLeafDataNode(fieldName, DataNode.Type.SINGLE_INSTANCE_NODE);
    }

    private void addMultiInstanceNodeToDataTree(String fieldName) {
        this.addNoneLeafDataNode(fieldName, DataNode.Type.MULTI_INSTANCE_NODE);
    }

    private void addLeafNodeToDataTree(String fieldName, JsonNode jsonNode) {
        String value = jsonNode.asText();
        this.addLeafDataNode(fieldName, value, DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
    }

    private void addLeafListNodeToDataTree(String fieldName, ArrayNode jsonNode) {
        Iterator elements = jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            JsonNodeType eleType = element.getNodeType();
            if (eleType != JsonNodeType.STRING && eleType != JsonNodeType.NUMBER) continue;
            this.addLeafDataNode(fieldName, element.asText(), DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE);
            this.dataNodeBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dataNodeBuilder);
        }
    }

    private boolean isJsonNodeLeafList(ArrayNode jsonNode) {
        if (!jsonNode.isArray()) {
            return false;
        }
        Iterator elements = jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            JsonNodeType eleType = element.getNodeType();
            if (eleType == JsonNodeType.STRING || eleType == JsonNodeType.NUMBER) continue;
            return false;
        }
        return true;
    }
}

