/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.jsonlist.rev20160624.jsonlist.top1;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of c2.
 */
public interface C2 extends Augmentable  {

    /**
     * Identify the leaf of C2.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1.
         */
        LEAF1(1),
        /**
         * Represents leaf2.
         */
        LEAF2(2),
        /**
         * Represents leaf3.
         */
        LEAF3(3),
        /**
         * Represents leaf4.
         */
        LEAF4(4),
        /**
         * Represents leaf5.
         */
        LEAF5(5),
        /**
         * Represents leaf6.
         */
        LEAF6(6),
        /**
         * Represents leaf7.
         */
        LEAF7(7),
        /**
         * Represents leaf8.
         */
        LEAF8(8),
        /**
         * Represents leaf9.
         */
        LEAF9(9),
        /**
         * Represents leaf10.
         */
        LEAF10(10),
        /**
         * Represents leaflist1.
         */
        LEAFLIST1(11),
        /**
         * Represents ll1.
         */
        LL1(12),
        /**
         * Represents ll2.
         */
        LL2(13),
        /**
         * Represents ll3.
         */
        LL3(14),
        /**
         * Represents ll4.
         */
        LL4(15),
        /**
         * Represents ll5.
         */
        LL5(16),
        /**
         * Represents ll6.
         */
        LL6(17),
        /**
         * Represents ll7.
         */
        LL7(18),
        /**
         * Represents ll8.
         */
        LL8(19),
        /**
         * Represents ll9.
         */
        LL9(20),
        /**
         * Represents ll10.
         */
        LL10(21);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    byte leaf1();

    /**
     * Returns the attribute leaf2.
     *
     * @return leaf2 value of leaf2
     */
    short leaf2();

    /**
     * Returns the attribute leaf3.
     *
     * @return leaf3 value of leaf3
     */
    int leaf3();

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 value of leaf4
     */
    short leaf4();

    /**
     * Returns the attribute leaf5.
     *
     * @return leaf5 value of leaf5
     */
    int leaf5();

    /**
     * Returns the attribute leaf6.
     *
     * @return leaf6 value of leaf6
     */
    long leaf6();

    /**
     * Returns the attribute leaf7.
     *
     * @return leaf7 value of leaf7
     */
    long leaf7();

    /**
     * Returns the attribute leaf8.
     *
     * @return leaf8 value of leaf8
     */
    BigInteger leaf8();

    /**
     * Returns the attribute leaf9.
     *
     * @return leaf9 value of leaf9
     */
    boolean leaf9();

    /**
     * Returns the attribute leaf10.
     *
     * @return leaf10 value of leaf10
     */
    BigDecimal leaf10();

    /**
     * Returns the attribute leaflist1.
     *
     * @return leaflist1 list of leaflist1
     */
    List<String> leaflist1();

    /**
     * Returns the attribute ll1.
     *
     * @return ll1 list of ll1
     */
    List<Byte> ll1();

    /**
     * Returns the attribute ll2.
     *
     * @return ll2 list of ll2
     */
    List<Short> ll2();

    /**
     * Returns the attribute ll3.
     *
     * @return ll3 list of ll3
     */
    List<Integer> ll3();

    /**
     * Returns the attribute ll4.
     *
     * @return ll4 list of ll4
     */
    List<Short> ll4();

    /**
     * Returns the attribute ll5.
     *
     * @return ll5 list of ll5
     */
    List<Integer> ll5();

    /**
     * Returns the attribute ll6.
     *
     * @return ll6 list of ll6
     */
    List<Long> ll6();

    /**
     * Returns the attribute ll7.
     *
     * @return ll7 list of ll7
     */
    List<Long> ll7();

    /**
     * Returns the attribute ll8.
     *
     * @return ll8 list of ll8
     */
    List<BigInteger> ll8();

    /**
     * Returns the attribute ll9.
     *
     * @return ll9 list of ll9
     */
    List<Boolean> ll9();

    /**
     * Returns the attribute ll10.
     *
     * @return ll10 list of ll10
     */
    List<BigDecimal> ll10();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    void leaf1(byte leaf1);

    /**
     * Sets the attribute leaf2.
     *
     * @param leaf2 value of leaf2
     */
    void leaf2(short leaf2);

    /**
     * Sets the attribute leaf3.
     *
     * @param leaf3 value of leaf3
     */
    void leaf3(int leaf3);

    /**
     * Sets the attribute leaf4.
     *
     * @param leaf4 value of leaf4
     */
    void leaf4(short leaf4);

    /**
     * Sets the attribute leaf5.
     *
     * @param leaf5 value of leaf5
     */
    void leaf5(int leaf5);

    /**
     * Sets the attribute leaf6.
     *
     * @param leaf6 value of leaf6
     */
    void leaf6(long leaf6);

    /**
     * Sets the attribute leaf7.
     *
     * @param leaf7 value of leaf7
     */
    void leaf7(long leaf7);

    /**
     * Sets the attribute leaf8.
     *
     * @param leaf8 value of leaf8
     */
    void leaf8(BigInteger leaf8);

    /**
     * Sets the attribute leaf9.
     *
     * @param leaf9 value of leaf9
     */
    void leaf9(boolean leaf9);

    /**
     * Sets the attribute leaf10.
     *
     * @param leaf10 value of leaf10
     */
    void leaf10(BigDecimal leaf10);

    /**
     * Sets the attribute leaflist1.
     *
     * @param leaflist1 list of leaflist1
     */
    void leaflist1(List<String> leaflist1);

    /**
     * Sets the attribute ll1.
     *
     * @param ll1 list of ll1
     */
    void ll1(List<Byte> ll1);

    /**
     * Sets the attribute ll2.
     *
     * @param ll2 list of ll2
     */
    void ll2(List<Short> ll2);

    /**
     * Sets the attribute ll3.
     *
     * @param ll3 list of ll3
     */
    void ll3(List<Integer> ll3);

    /**
     * Sets the attribute ll4.
     *
     * @param ll4 list of ll4
     */
    void ll4(List<Short> ll4);

    /**
     * Sets the attribute ll5.
     *
     * @param ll5 list of ll5
     */
    void ll5(List<Integer> ll5);

    /**
     * Sets the attribute ll6.
     *
     * @param ll6 list of ll6
     */
    void ll6(List<Long> ll6);

    /**
     * Sets the attribute ll7.
     *
     * @param ll7 list of ll7
     */
    void ll7(List<Long> ll7);

    /**
     * Sets the attribute ll8.
     *
     * @param ll8 list of ll8
     */
    void ll8(List<BigInteger> ll8);

    /**
     * Sets the attribute ll9.
     *
     * @param ll9 list of ll9
     */
    void ll9(List<Boolean> ll9);

    /**
     * Sets the attribute ll10.
     *
     * @param ll10 list of ll10
     */
    void ll10(List<BigDecimal> ll10);

    /**
     * Adds to the list of leaflist1.
     *
     * @param addTo value of leaflist1
     */
    void addToLeaflist1(String addTo);

    /**
     * Adds to the list of ll1.
     *
     * @param addTo value of ll1
     */
    void addToLl1(Byte addTo);

    /**
     * Adds to the list of ll2.
     *
     * @param addTo value of ll2
     */
    void addToLl2(Short addTo);

    /**
     * Adds to the list of ll3.
     *
     * @param addTo value of ll3
     */
    void addToLl3(Integer addTo);

    /**
     * Adds to the list of ll4.
     *
     * @param addTo value of ll4
     */
    void addToLl4(Short addTo);

    /**
     * Adds to the list of ll5.
     *
     * @param addTo value of ll5
     */
    void addToLl5(Integer addTo);

    /**
     * Adds to the list of ll6.
     *
     * @param addTo value of ll6
     */
    void addToLl6(Long addTo);

    /**
     * Adds to the list of ll7.
     *
     * @param addTo value of ll7
     */
    void addToLl7(Long addTo);

    /**
     * Adds to the list of ll8.
     *
     * @param addTo value of ll8
     */
    void addToLl8(BigInteger addTo);

    /**
     * Adds to the list of ll9.
     *
     * @param addTo value of ll9
     */
    void addToLl9(Boolean addTo);

    /**
     * Adds to the list of ll10.
     *
     * @param addTo value of ll10
     */
    void addToLl10(BigDecimal addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}