/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import org.onosproject.yang.model.LeafType;
import org.onosproject.yang.serializers.json.JsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonBuilder
implements JsonBuilder {
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String QUOTE = "\"";
    private static final String ROOT_MODULE_NAME = "ROOT";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private StringBuilder treeString;
    private Stack<String> moduleNameStack;

    public DefaultJsonBuilder(String rootName) {
        Preconditions.checkNotNull((Object)rootName);
        this.treeString = new StringBuilder(rootName);
        this.moduleNameStack = new Stack();
    }

    public DefaultJsonBuilder() {
        this.treeString = new StringBuilder();
        this.moduleNameStack = new Stack();
    }

    @Override
    public void addNodeTopHalf(String nodeName, JsonNodeType nodeType) {
        this.appendField(nodeName);
        switch (nodeType) {
            case OBJECT: {
                this.treeString.append(LEFT_BRACE);
                break;
            }
            case ARRAY: {
                this.treeString.append(LEFT_BRACKET);
                break;
            }
            default: {
                this.log.error("Unknown support type {} for this method.", (Object)nodeType);
            }
        }
    }

    @Override
    public void addNodeWithValueTopHalf(String nodeName, String value, String valNamespace, LeafType type) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            return;
        }
        this.appendField(nodeName);
        if (valNamespace != null) {
            this.treeString.append(QUOTE);
            this.treeString.append(valNamespace);
            this.treeString.append(COLON);
        }
        this.appendLeafValue(type, value, valNamespace);
        this.treeString.append(COMMA);
    }

    private void appendLeafValue(LeafType type, String v, String ns) {
        switch (type) {
            case INT8: 
            case INT16: 
            case UINT8: 
            case INT32: 
            case UINT16: 
            case UINT32: 
            case BOOLEAN: {
                this.treeString.append(v);
                break;
            }
            default: {
                if (ns == null) {
                    this.treeString.append(QUOTE);
                }
                this.treeString.append(v);
                this.treeString.append(QUOTE);
            }
        }
    }

    @Override
    public void addNodeWithSetTopHalf(String nodeName, Set<String> sets) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            return;
        }
        this.appendField(nodeName);
        this.treeString.append(LEFT_BRACKET);
        for (String el : sets) {
            this.treeString.append(QUOTE);
            this.treeString.append(el);
            this.treeString.append(QUOTE);
            this.treeString.append(COMMA);
        }
    }

    @Override
    public void addValueToLeafListNode(String v, String ns, LeafType t) {
        if (Strings.isNullOrEmpty((String)v)) {
            return;
        }
        if (ns != null) {
            this.treeString.append(QUOTE);
            this.treeString.append(ns);
            this.treeString.append(COLON);
        }
        this.appendLeafValue(t, v, ns);
        this.treeString.append(COMMA);
    }

    @Override
    public void addNodeBottomHalf(JsonNodeType nodeType) {
        switch (nodeType) {
            case OBJECT: {
                this.removeCommaIfExist();
                this.treeString.append(RIGHT_BRACE);
                this.treeString.append(COMMA);
                break;
            }
            case ARRAY: {
                this.removeCommaIfExist();
                this.treeString.append(RIGHT_BRACKET);
                this.treeString.append(COMMA);
                break;
            }
            case BINARY: 
            case BOOLEAN: 
            case MISSING: 
            case NULL: 
            case NUMBER: 
            case POJO: 
            case STRING: {
                break;
            }
            default: {
                this.log.info("Unknown json node type {}", (Object)nodeType);
            }
        }
    }

    @Override
    public String getTreeString() {
        return this.treeString.toString();
    }

    private void removeFirstFieldNameIfExist() {
        int index1 = this.treeString.indexOf(LEFT_BRACE);
        int index2 = this.treeString.indexOf(LEFT_BRACKET);
        if (index1 < 0 && index2 < 0) {
            return;
        }
        int index = index1 < 0 ? index2 : (index2 < 0 ? index1 : (index1 < index2 ? index1 : index2));
        this.treeString.delete(0, index);
    }

    @Override
    public ObjectNode getTreeNode() {
        ObjectNode node = null;
        try {
            ObjectMapper m = new ObjectMapper();
            m.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            node = (ObjectNode)m.readTree(this.getTreeString());
        }
        catch (IOException e) {
            this.log.error("Error in processing the tree", (Throwable)e);
            this.log.debug("tree {}", (Object)this.getTreeString());
        }
        return node;
    }

    @Override
    public String subTreeModuleName() {
        return this.moduleNameStack.peek();
    }

    @Override
    public void pushModuleName(String moduleName) {
        this.moduleNameStack.push(moduleName);
    }

    @Override
    public void popModuleName() {
        this.moduleNameStack.pop();
    }

    @Override
    public void initializeJson() {
        if (!this.moduleNameStack.empty()) {
            this.moduleNameStack.removeAllElements();
        }
        this.moduleNameStack.push(ROOT_MODULE_NAME);
        this.treeString.setLength(0);
        this.treeString.append(LEFT_BRACE);
    }

    @Override
    public void finalizeJson(boolean isRootTypeMultiInstance) {
        this.removeCommaIfExist();
        if (isRootTypeMultiInstance) {
            this.treeString.append(RIGHT_BRACKET);
        }
        this.treeString.append(RIGHT_BRACE);
    }

    private void appendField(String fieldName) {
        if (fieldName != null && !fieldName.isEmpty()) {
            this.treeString.append(QUOTE);
            this.treeString.append(fieldName);
            this.treeString.append(QUOTE);
            this.treeString.append(COLON);
        }
    }

    private void removeCommaIfExist() {
        if (this.treeString.charAt(this.treeString.length() - 1) == COMMA.charAt(0)) {
            this.treeString.deleteCharAt(this.treeString.length() - 1);
        }
    }
}

