/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.json.DataNodeJsonVisitor;
import org.onosproject.yang.serializers.json.DataNodeSiblingPositionType;
import org.onosproject.yang.serializers.json.DataNodeVisitor;
import org.onosproject.yang.serializers.json.DefaultJsonBuilder;

public final class EncoderUtils {
    private EncoderUtils() {
    }

    public static ObjectNode convertDataNodeToJson(DataNode dataNode, YangSerializerContext context) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data node cannot be null");
        DefaultJsonBuilder jsonBuilder = new DefaultJsonBuilder();
        jsonBuilder.initializeJson();
        DataNodeJsonVisitor treeNodeListener = new DataNodeJsonVisitor(jsonBuilder, context);
        DataNodeSiblingPositionType siblingType = dataNode.type() == DataNode.Type.MULTI_INSTANCE_NODE ? DataNodeSiblingPositionType.FIRST_INSTANCE : DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        EncoderUtils.walkDataNodeTree(treeNodeListener, dataNode, siblingType);
        jsonBuilder.finalizeJson(dataNode.type() == DataNode.Type.MULTI_INSTANCE_NODE);
        return jsonBuilder.getTreeNode();
    }

    private static void walkDataNodeTree(DataNodeVisitor dataNodeVisitor, DataNode dataNode, DataNodeSiblingPositionType siblingType) {
        Preconditions.checkNotNull((Object)dataNode, (Object)"data tree cannot be null");
        Preconditions.checkNotNull((Object)dataNodeVisitor, (Object)"dataNodeVisitor cannot be null");
        dataNodeVisitor.enterDataNode(dataNode, siblingType);
        if (dataNode.type() == DataNode.Type.SINGLE_INSTANCE_NODE || dataNode.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
            EncoderUtils.walkChildNodeList(dataNodeVisitor, dataNode);
        }
        dataNodeVisitor.exitDataNode(dataNode, siblingType);
    }

    private static void walkChildNodeList(DataNodeVisitor dataNodeVisitor, DataNode dataNode) {
        if (dataNode.type() != DataNode.Type.SINGLE_INSTANCE_NODE && dataNode.type() != DataNode.Type.MULTI_INSTANCE_NODE) {
            return;
        }
        Map childrenList = ((InnerNode)dataNode).childNodes();
        if (childrenList == null || childrenList.isEmpty()) {
            return;
        }
        DataNodeSiblingPositionType prevChildType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        List<DataNode> sortedChildList = EncoderUtils.sortChildrenList(childrenList);
        Iterator<DataNode> it = sortedChildList.iterator();
        DataNode currChild = it.next();
        boolean lastChildNotProcessed = true;
        while (lastChildNotProcessed) {
            DataNode nextChild;
            if (it.hasNext()) {
                nextChild = it.next();
            } else {
                lastChildNotProcessed = false;
                nextChild = null;
            }
            DataNodeSiblingPositionType currChildType = EncoderUtils.getCurrentChildSiblingType(currChild, nextChild, prevChildType);
            EncoderUtils.walkDataNodeTree(dataNodeVisitor, currChild, currChildType);
            prevChildType = currChildType;
            currChild = nextChild;
        }
    }

    private static DataNodeSiblingPositionType getCurrentChildSiblingType(DataNode currChild, DataNode nextChild, DataNodeSiblingPositionType prevChildType) {
        if (currChild.type() != DataNode.Type.MULTI_INSTANCE_NODE && currChild.type() != DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            return DataNodeSiblingPositionType.NOT_MULTI_INSTANCE_NODE;
        }
        DataNodeSiblingPositionType curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
        switch (prevChildType) {
            case UNKNOWN_TYPE: 
            case LAST_INSTANCE: 
            case NOT_MULTI_INSTANCE_NODE: 
            case SINGLE_INSTANCE_IN_MULTI_NODE: {
                if (nextChild == null || !nextChild.key().schemaId().name().equals(currChild.key().schemaId().name())) {
                    curChildSiblingType = DataNodeSiblingPositionType.SINGLE_INSTANCE_IN_MULTI_NODE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.FIRST_INSTANCE;
                break;
            }
            case FIRST_INSTANCE: 
            case MIDDLE_INSTANCE: {
                if (nextChild != null && nextChild.key().schemaId().name().equals(currChild.key().schemaId().name())) {
                    curChildSiblingType = DataNodeSiblingPositionType.MIDDLE_INSTANCE;
                    break;
                }
                curChildSiblingType = DataNodeSiblingPositionType.LAST_INSTANCE;
                break;
            }
            default: {
                curChildSiblingType = DataNodeSiblingPositionType.UNKNOWN_TYPE;
            }
        }
        return curChildSiblingType;
    }

    private static List<DataNode> sortChildrenList(Map<NodeKey, DataNode> childrenList) {
        ArrayList sortedList = new ArrayList();
        HashMap<String, List> groupedBucket = new HashMap<String, List>();
        for (Map.Entry<NodeKey, DataNode> entry : childrenList.entrySet()) {
            DataNode dataNode = entry.getValue();
            String nodeName = dataNode.key().schemaId().name();
            List group = groupedBucket.computeIfAbsent(nodeName, k -> new ArrayList());
            group.add(dataNode);
        }
        for (Map.Entry<Object, Object> entry : groupedBucket.entrySet()) {
            sortedList.addAll((Collection)entry.getValue());
        }
        return sortedList.stream().sorted(Comparator.comparing(object -> object.key().schemaId().name())).collect(Collectors.toList());
    }
}

