/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715.demo1;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of device.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDevice extends InnerModelObject implements Device {
    protected String reqStartDateTime;
    protected String reqEndDateTime;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device> device;

    @Override
    public String reqStartDateTime() {
        return reqStartDateTime;
    }

    @Override
    public String reqEndDateTime() {
        return reqEndDateTime;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device> device() {
        return device;
    }

    @Override
    public void reqStartDateTime(String reqStartDateTime) {
        valueLeafFlags.set(LeafIdentifier.REQSTARTDATETIME.getLeafIndex());
        this.reqStartDateTime = reqStartDateTime;
    }

    @Override
    public void reqEndDateTime(String reqEndDateTime) {
        valueLeafFlags.set(LeafIdentifier.REQENDDATETIME.getLeafIndex());
        this.reqEndDateTime = reqEndDateTime;
    }

    @Override
    public void device(List<org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device> device) {
        this.device = device;
    }

    @Override
    public void addToDevice(org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device addTo) {
        if (device == null) {
            device = new ArrayList<>();
        }
        device.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(reqStartDateTime, reqEndDateTime, valueLeafFlags, device);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDevice) {
            DefaultDevice other = (DefaultDevice) obj;
            return
                Objects.deepEquals(reqStartDateTime, other.reqStartDateTime) &&
                Objects.deepEquals(reqEndDateTime, other.reqEndDateTime) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(device, other.device);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("reqStartDateTime=" + reqStartDateTime)
            .add("reqEndDateTime=" + reqEndDateTime)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("device=" + device)
            .toString();
    }


    /**
     * Creates an instance of defaultDevice.
     */
    public DefaultDevice() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}